/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.variant;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionFinder;
import hudson.PluginWrapper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.jenkinsci.plugins.variant.OptionalPackage;
import org.jenkinsci.plugins.variant.VariantSet;

@Extension
public class OptionalExtensionProcessor
extends ExtensionFinder.GuiceExtensionAnnotation<OptionalExtension> {
    public OptionalExtensionProcessor() {
        super(OptionalExtension.class);
    }

    protected double getOrdinal(OptionalExtension annotation) {
        return annotation.ordinal();
    }

    protected boolean isOptional(OptionalExtension annotation) {
        return true;
    }

    protected boolean isActive(AnnotatedElement e) {
        while (e != null) {
            try {
                OptionalExtension a = e.getAnnotation(OptionalExtension.class);
                if (a != null && !this.isActive(a)) {
                    return false;
                }
            }
            catch (ArrayStoreException e1) {
                return false;
            }
            try {
                OptionalPackage b = e.getAnnotation(OptionalPackage.class);
                if (b != null && !this.isActive(b)) {
                    return false;
                }
            }
            catch (ArrayStoreException e1) {
                return false;
            }
            e = this.getParentOf(e);
        }
        return true;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private boolean isActive(OptionalExtension a) {
        try {
            a.requireClasses();
        }
        catch (ArrayStoreException x) {
            return false;
        }
        catch (TypeNotPresentException x) {
            return false;
        }
        for (String name : a.requirePlugins()) {
            PluginWrapper p = Jenkins.getInstance().pluginManager.getPlugin(name);
            if (p != null && p.isActive()) continue;
            return false;
        }
        for (String name : a.requireVariants()) {
            if (VariantSet.INSTANCE.contains(name)) continue;
            return false;
        }
        return true;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private boolean isActive(OptionalPackage a) {
        try {
            a.requireClasses();
        }
        catch (ArrayStoreException x) {
            return false;
        }
        catch (TypeNotPresentException x) {
            return false;
        }
        for (String name : a.requirePlugins()) {
            PluginWrapper p = Jenkins.getInstance().pluginManager.getPlugin(name);
            if (p != null && p.isActive()) continue;
            return false;
        }
        for (String name : a.requireVariants()) {
            if (VariantSet.INSTANCE.contains(name)) continue;
            return false;
        }
        return true;
    }

    private AnnotatedElement getParentOf(AnnotatedElement e) {
        if (e instanceof Member) {
            return ((Member)((Object)e)).getDeclaringClass();
        }
        if (e instanceof Class) {
            return ((Class)e).getPackage();
        }
        return null;
    }
}

