/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.AbstractFlowScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowNodeVisitor;

@NotThreadSafe
public class LinearScanner
extends AbstractFlowScanner {
    private static final Logger LOGGER = Logger.getLogger(LinearScanner.class.getName());

    @Override
    protected void reset() {
        this.myCurrent = null;
        this.myNext = null;
        this.myBlackList = Collections.emptySet();
    }

    @Override
    protected void setHeads(@NonNull Collection<FlowNode> heads) {
        Iterator<FlowNode> it = heads.iterator();
        if (it.hasNext()) {
            this.myNext = this.myCurrent = it.next();
            if (it.hasNext()) {
                LOGGER.log(Level.WARNING, null, new IllegalArgumentException("Multiple heads not supported for linear scanners"));
            }
        }
    }

    @Override
    protected FlowNode next(@CheckForNull FlowNode current, @NonNull Collection<FlowNode> blackList) {
        if (current == null) {
            return null;
        }
        List<FlowNode> parents = current.getParents();
        if (parents != null && parents.size() > 0) {
            for (FlowNode f : parents) {
                if (blackList.contains((Object)f)) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    @NonNull
    public List<FlowNode> filteredNodes(Collection<FlowNode> heads, @NonNull Predicate<FlowNode> matchPredicate) {
        return super.filteredNodes(heads, matchPredicate);
    }

    @Override
    @NonNull
    public List<FlowNode> filteredNodes(Collection<FlowNode> heads, Collection<FlowNode> blackList, Predicate<FlowNode> matchCondition) {
        return super.filteredNodes(heads, blackList, matchCondition);
    }

    @Override
    @Deprecated
    public FlowNode findFirstMatch(Collection<FlowNode> heads, @NonNull Predicate<FlowNode> matchPredicate) {
        return super.findFirstMatch(heads, matchPredicate);
    }

    @Override
    public FlowNode findFirstMatch(Collection<FlowNode> heads, Collection<FlowNode> blackListNodes, Predicate<FlowNode> matchCondition) {
        return super.findFirstMatch(heads, blackListNodes, matchCondition);
    }

    @Override
    public void visitAll(Collection<FlowNode> heads, @NonNull FlowNodeVisitor visitor) {
        super.visitAll(heads, visitor);
    }

    @Override
    public void visitAll(Collection<FlowNode> heads, Collection<FlowNode> blackList, @NonNull FlowNodeVisitor visitor) {
        super.visitAll(heads, blackList, visitor);
    }

    @Override
    @Deprecated
    public FlowNode findFirstMatch(FlowExecution exec, @NonNull Predicate<FlowNode> matchPredicate) {
        return super.findFirstMatch(exec, matchPredicate);
    }

    @Override
    @Deprecated
    public boolean setup(Collection<FlowNode> heads) {
        return super.setup(heads);
    }

    @Override
    @Deprecated
    public boolean setup(Collection<FlowNode> heads, Collection<FlowNode> blackList) {
        return super.setup(heads, blackList);
    }
}

