/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graph.GraphLookupView;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Can can use instance identity when comparing to a final constant")
public final class StandardGraphLookupView
implements GraphLookupView,
GraphListener,
GraphListener.Synchronous {
    static final String INCOMPLETE = "";
    HashMap<String, String> blockStartToEnd = new HashMap();
    HashMap<String, String> nearestEnclosingBlock = new HashMap();

    public void clearCache() {
        this.blockStartToEnd.clear();
        this.nearestEnclosingBlock.clear();
    }

    @Override
    public void onNewHead(@Nonnull FlowNode newHead) {
        if (newHead instanceof BlockEndNode) {
            this.blockStartToEnd.put(((FlowNode)((Object)((BlockEndNode)newHead).getStartNode())).getId(), newHead.getId());
            String overallEnclosing = this.nearestEnclosingBlock.get(((FlowNode)((Object)((BlockEndNode)newHead).getStartNode())).getId());
            if (overallEnclosing != null) {
                this.nearestEnclosingBlock.put(newHead.getId(), overallEnclosing);
            }
        } else {
            List<FlowNode> parents;
            if (newHead instanceof BlockStartNode) {
                this.blockStartToEnd.put(newHead.getId(), INCOMPLETE);
            }
            if ((parents = newHead.getParents()).size() > 0) {
                FlowNode parent = parents.get(0);
                if (parent instanceof BlockStartNode) {
                    this.nearestEnclosingBlock.put(newHead.getId(), parent.getId());
                } else {
                    String lookupId = parent instanceof BlockEndNode ? ((FlowNode)((Object)((BlockEndNode)parent).getStartNode())).getId() : parent.getId();
                    String enclosingId = this.nearestEnclosingBlock.get(lookupId);
                    if (enclosingId != null) {
                        this.nearestEnclosingBlock.put(newHead.getId(), enclosingId);
                    }
                }
            }
        }
    }

    @Override
    public boolean isActive(@Nonnull FlowNode node) {
        if (node instanceof FlowEndNode) {
            return !node.getExecution().isComplete();
        }
        if (node instanceof BlockStartNode) {
            return this.getEndNode((BlockStartNode)node) == null;
        }
        return node.getExecution().isCurrentHead(node);
    }

    BlockEndNode bruteForceScanForEnd(@Nonnull BlockStartNode start) {
        DepthFirstScanner scan = new DepthFirstScanner();
        scan.setup(start.getExecution().getCurrentHeads());
        for (FlowNode f : scan) {
            if (f instanceof BlockEndNode) {
                BlockEndNode end = (BlockEndNode)f;
                Object maybeStart = end.getStartNode();
                this.blockStartToEnd.put(((FlowNode)((Object)maybeStart)).getId(), end.getId());
                if (!start.equals(maybeStart)) continue;
                return end;
            }
            if (!(f instanceof BlockStartNode)) continue;
            BlockStartNode maybeThis = (BlockStartNode)f;
            this.blockStartToEnd.putIfAbsent(maybeThis.getId(), INCOMPLETE);
            if (!start.equals((Object)maybeThis)) continue;
            return null;
        }
        return null;
    }

    BlockStartNode bruteForceScanForEnclosingBlock(@Nonnull FlowNode node) {
        FlowNode current = node;
        while (!(current instanceof FlowStartNode)) {
            String enclosingIdFromCache;
            if (current instanceof BlockEndNode) {
                Object start = ((BlockEndNode)current).getStartNode();
                this.blockStartToEnd.put(((FlowNode)((Object)start)).getId(), current.getId());
                current = start;
                continue;
            }
            if (current != node && (enclosingIdFromCache = this.nearestEnclosingBlock.get(current.getId())) != null) {
                try {
                    return (BlockStartNode)node.getExecution().getNode(enclosingIdFromCache);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            if (current.getParents().isEmpty()) {
                return null;
            }
            FlowNode parent = current.getParents().get(0);
            if (parent instanceof BlockStartNode) {
                this.nearestEnclosingBlock.put(current.getId(), parent.getId());
                return (BlockStartNode)parent;
            }
            current = parent;
        }
        return null;
    }

    @Override
    @CheckForNull
    public BlockEndNode getEndNode(@Nonnull BlockStartNode startNode) {
        String id = this.blockStartToEnd.get(startNode.getId());
        if (id != null) {
            try {
                return id == INCOMPLETE ? null : (BlockEndNode)startNode.getExecution().getNode(id);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        BlockEndNode node = this.bruteForceScanForEnd(startNode);
        if (node != null) {
            this.blockStartToEnd.put(startNode.getId(), node.getId());
        }
        return node;
    }

    @Override
    @CheckForNull
    public BlockStartNode findEnclosingBlockStart(@Nonnull FlowNode node) {
        if (node instanceof FlowStartNode || node instanceof FlowEndNode) {
            return null;
        }
        String id = this.nearestEnclosingBlock.get(node.getId());
        if (id != null) {
            try {
                return (BlockStartNode)node.getExecution().getNode(id);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        BlockStartNode enclosing = this.bruteForceScanForEnclosingBlock(node);
        if (enclosing != null) {
            this.nearestEnclosingBlock.put(node.getId(), enclosing.getId());
            return enclosing;
        }
        return null;
    }

    @Override
    public Iterable<BlockStartNode> iterateEnclosingBlocks(@Nonnull FlowNode node) {
        return new GraphLookupView.EnclosingBlocksIterable(this, node);
    }

    @Override
    @Nonnull
    public List<BlockStartNode> findAllEnclosingBlockStarts(@Nonnull FlowNode node) {
        if (node instanceof FlowStartNode || node instanceof FlowEndNode) {
            return Collections.emptyList();
        }
        ArrayList<BlockStartNode> starts = new ArrayList<BlockStartNode>(2);
        BlockStartNode currentlyEnclosing = this.findEnclosingBlockStart(node);
        while (currentlyEnclosing != null) {
            starts.add(currentlyEnclosing);
            currentlyEnclosing = this.findEnclosingBlockStart(currentlyEnclosing);
        }
        return starts;
    }
}

