/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import com.jcraft.jzlib.GZIPInputStream;
import com.jcraft.jzlib.GZIPOutputStream;
import hudson.console.ConsoleAnnotator;
import hudson.remoting.ClassFilter;
import hudson.remoting.ObjectInputStreamEx;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import jenkins.model.Jenkins;
import jenkins.security.CryptoConfidentialKey;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Restricted(value={Beta.class})
public class ConsoleAnnotators {
    private static final CryptoConfidentialKey PASSING_ANNOTATOR = new CryptoConfidentialKey(ConsoleAnnotators.class, "consoleAnnotator");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> ConsoleAnnotator<T> createAnnotator(T context) throws IOException {
        StaplerRequest req = Stapler.getCurrentRequest();
        try {
            String base64 = req != null ? req.getHeader("X-ConsoleAnnotator") : null;
            if (base64 == null) return ConsoleAnnotator.initial(context);
            Cipher sym = PASSING_ANNOTATOR.decrypt();
            try (ObjectInputStreamEx ois = new ObjectInputStreamEx((InputStream)new GZIPInputStream((InputStream)new CipherInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8))), sym)), Jenkins.get().pluginManager.uberClassLoader, ClassFilter.DEFAULT);){
                ConsoleAnnotator annotator;
                long timestamp = ois.readLong();
                if (TimeUnit.HOURS.toMillis(1L) <= Math.abs(System.currentTimeMillis() - timestamp)) return ConsoleAnnotator.initial(context);
                ConsoleAnnotator consoleAnnotator = annotator = (ConsoleAnnotator)ois.readObject();
                return consoleAnnotator;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static void setAnnotator(ConsoleAnnotator<?> annotator) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Cipher sym = PASSING_ANNOTATOR.encrypt();
        try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new GZIPOutputStream((OutputStream)new CipherOutputStream((OutputStream)baos, sym)));){
            oos.writeLong(System.currentTimeMillis());
            oos.writeObject(annotator);
        }
        StaplerResponse rsp = Stapler.getCurrentResponse();
        if (rsp != null) {
            rsp.setHeader("X-ConsoleAnnotator", new String(Base64.getEncoder().encode(baos.toByteArray()), StandardCharsets.US_ASCII));
        }
    }

    private ConsoleAnnotators() {
    }
}

