/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.security.Permission;
import hudson.util.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.kohsuke.stapler.StaplerRequest;

public class GlobalDefaultFlowDurabilityLevel
extends AbstractDescribableImpl<GlobalDefaultFlowDurabilityLevel> {
    public static final FlowDurabilityHint SUGGESTED_DURABILITY_HINT = FlowDurabilityHint.MAX_SURVIVABILITY;

    public static FlowDurabilityHint getDefaultDurabilityHint() {
        FlowDurabilityHint hint;
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null && (hint = ((DescriptorImpl)((Object)j.getExtensionList(DescriptorImpl.class).get(0))).durabilityHint) != null) {
            return hint;
        }
        return SUGGESTED_DURABILITY_HINT;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GlobalDefaultFlowDurabilityLevel> {
        private FlowDurabilityHint durabilityHint = null;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Global Default Pipeline Durability Level";
        }

        @CheckForNull
        public FlowDurabilityHint getDurabilityHint() {
            return this.durabilityHint;
        }

        public void setDurabilityHint(FlowDurabilityHint hint) {
            this.durabilityHint = hint;
            this.save();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            Object ob = json.opt("durabilityHint");
            FlowDurabilityHint hint = null;
            if (ob instanceof String) {
                String str = (String)ob;
                for (FlowDurabilityHint maybeHint : FlowDurabilityHint.values()) {
                    if (!maybeHint.name().equals(str)) continue;
                    hint = maybeHint;
                    break;
                }
            }
            this.setDurabilityHint(hint);
            return true;
        }

        public static FlowDurabilityHint getSuggestedDurabilityHint() {
            return SUGGESTED_DURABILITY_HINT;
        }

        public static FlowDurabilityHint[] getDurabilityHintValues() {
            return FlowDurabilityHint.values();
        }

        @Nonnull
        public Permission getRequiredGlobalConfigPagePermission() {
            return this.getJenkinsManageOrAdmin();
        }

        Permission getJenkinsManageOrAdmin() {
            Permission manage;
            try {
                manage = (Permission)ReflectionUtils.getPublicProperty((Object)Jenkins.get(), (String)"MANAGE");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                manage = Jenkins.ADMINISTER;
            }
            return manage;
        }
    }
}

