/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import jenkins.MasterToSlaveFileCallable;
import jenkins.util.BuildListenerAdapter;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.ArtifactArchiverStep;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class ArtifactArchiverStepExecution
extends AbstractSynchronousNonBlockingStepExecution<Void> {
    @StepContextParameter
    private transient TaskListener listener;
    @StepContextParameter
    private transient FilePath ws;
    @StepContextParameter
    private transient Run build;
    @StepContextParameter
    private transient Launcher launcher;
    @Inject
    private transient ArtifactArchiverStep step;
    private static final long serialVersionUID = 1L;

    protected Void run() throws Exception {
        Map files = (Map)this.ws.act((FilePath.FileCallable)new ListFiles(this.step.getIncludes(), this.step.getExcludes()));
        this.build.pickArtifactManager().archive(this.ws, this.launcher, (BuildListener)new BuildListenerAdapter(this.listener), files);
        return null;
    }

    private static final class ListFiles
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private static final long serialVersionUID = 1L;
        private final String includes;
        private final String excludes;

        ListFiles(String includes, String excludes) {
            this.includes = includes;
            this.excludes = excludes;
        }

        public Map<String, String> invoke(File basedir, VirtualChannel channel) throws IOException, InterruptedException {
            HashMap<String, String> r = new HashMap<String, String>();
            for (String f : Util.createFileSet((File)basedir, (String)this.includes, (String)this.excludes).getDirectoryScanner().getIncludedFiles()) {
                f = f.replace(File.separatorChar, '/');
                r.put(f, f);
            }
            return r;
        }
    }
}

