/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public final class CatchErrorStep
extends AbstractStepImpl {
    @DataBoundConstructor
    public CatchErrorStep() {
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient TaskListener listener;
        private static final long serialVersionUID = 1L;

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback()).start();
            return false;
        }

        public void stop(Throwable cause) throws Exception {
        }

        private static final class Callback
        extends BodyExecutionCallback {
            private Callback() {
            }

            public void onSuccess(StepContext context, Object result) {
                context.onSuccess(null);
            }

            public void onFailure(StepContext context, Throwable t) {
                try {
                    TaskListener listener = (TaskListener)context.get(TaskListener.class);
                    Result r = Result.FAILURE;
                    if (t instanceof AbortException) {
                        listener.error(t.getMessage());
                    } else if (t instanceof FlowInterruptedException) {
                        FlowInterruptedException fie = (FlowInterruptedException)t;
                        fie.handle((Run)context.get(Run.class), listener);
                        r = fie.getResult();
                    } else {
                        t.printStackTrace(listener.getLogger());
                    }
                    ((Run)context.get(Run.class)).setResult(r);
                    context.onSuccess(null);
                }
                catch (Exception x) {
                    context.onFailure((Throwable)x);
                }
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "catchError";
        }

        public String getDisplayName() {
            return "Catch error and set build result";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isAdvanced() {
            return true;
        }
    }
}

