/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.util.concurrent.FutureCallback;
import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class CoreWrapperStep
extends AbstractStepImpl {
    private final SimpleBuildWrapper delegate;

    @DataBoundConstructor
    public CoreWrapperStep(SimpleBuildWrapper delegate) {
        this.delegate = delegate;
    }

    public SimpleBuildWrapper getDelegate() {
        return this.delegate;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "wrap";
        }

        public String getDisplayName() {
            return "General Build Wrapper";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isMetaStep() {
            return true;
        }

        public Collection<BuildWrapperDescriptor> getApplicableDescriptors() {
            ArrayList<BuildWrapperDescriptor> r = new ArrayList<BuildWrapperDescriptor>();
            for (BuildWrapperDescriptor d : Jenkins.getActiveInstance().getExtensionList(BuildWrapperDescriptor.class)) {
                if (!SimpleBuildWrapper.class.isAssignableFrom(d.clazz)) continue;
                r.add(d);
            }
            return r;
        }
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final SimpleBuildWrapper.Disposer disposer;

        Callback(@Nonnull SimpleBuildWrapper.Disposer disposer) {
            this.disposer = disposer;
        }

        protected void finished(StepContext context) throws Exception {
            this.disposer.tearDown((Run)context.get(Run.class), (FilePath)context.get(FilePath.class), (Launcher)context.get(Launcher.class), (TaskListener)context.get(TaskListener.class));
        }
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> overrides;

        ExpanderImpl(Map<String, String> overrides) {
            this.overrides = new HashMap<String, String>(overrides);
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideExpandingAll(this.overrides);
        }
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient CoreWrapperStep step;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;

        public boolean start() throws Exception {
            SimpleBuildWrapper.Disposer disposer;
            ConsoleLogFilter filter;
            SimpleBuildWrapper.Context c = new SimpleBuildWrapper.Context();
            this.step.delegate.setUp(c, this.run, this.workspace, this.launcher, this.listener, this.env);
            BodyInvoker bodyInvoker = this.getContext().newBodyInvoker();
            Map overrides = c.getEnv();
            if (!overrides.isEmpty()) {
                bodyInvoker.withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(overrides)));
            }
            if ((filter = this.step.delegate.createLoggerDecorator(this.run)) != null) {
                bodyInvoker.withContext((Object)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class)), (ConsoleLogFilter)filter));
            }
            bodyInvoker.withCallback((BodyExecutionCallback)((disposer = c.getDisposer()) != null ? new Callback(disposer) : BodyExecutionCallback.wrap((FutureCallback)this.getContext()))).start();
            return false;
        }

        public void stop(Throwable cause) throws Exception {
        }
    }
}

