/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.util.concurrent.FutureCallback;
import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class EnvStep
extends AbstractStepImpl {
    private final List<String> overrides;

    @DataBoundConstructor
    public EnvStep(List<String> overrides) {
        for (String pair : overrides) {
            if (pair.indexOf(61) != -1) continue;
            throw new IllegalArgumentException(pair);
        }
        this.overrides = new ArrayList<String>(overrides);
    }

    public List<String> getOverrides() {
        return this.overrides;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "withEnv";
        }

        public String getDisplayName() {
            return "Set environment variables";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Step newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String overridesS = formData.getString("overrides");
            ArrayList<String> overrides = new ArrayList<String>();
            for (String line : overridesS.split("\r?\n")) {
                if ((line = line.trim()).isEmpty()) continue;
                overrides.add(line);
            }
            return new EnvStep(overrides);
        }
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> overrides = new HashMap<String, String>();

        private ExpanderImpl(List<String> overrides) {
            for (String pair : overrides) {
                int split = pair.indexOf(61);
                assert (split != -1);
                this.overrides.put(pair.substring(0, split), pair.substring(split + 1));
            }
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideAll(this.overrides);
        }
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient EnvStep step;

        public boolean start() throws Exception {
            this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(this.step.overrides))).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
            return false;
        }

        public void stop(Throwable cause) throws Exception {
        }
    }
}

