/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.Extension;
import hudson.FilePath;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public final class FileExistsStep
extends AbstractStepImpl {
    private final String file;

    @DataBoundConstructor
    public FileExistsStep(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        @Inject
        private transient FileExistsStep step;
        @StepContextParameter
        private transient FilePath workspace;
        private static final long serialVersionUID = 1L;

        protected Boolean run() throws Exception {
            return this.workspace.child(this.step.file).exists();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "fileExists";
        }

        public String getDisplayName() {
            return "Verify if file exists in workspace";
        }
    }
}

