/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class PushdStep
extends AbstractStepImpl {
    private final String path;

    @DataBoundConstructor
    public PushdStep(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        @Inject(optional=true)
        private transient PushdStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath cwd;
        private BodyExecution body;
        private static final long serialVersionUID = 1L;

        public boolean start() throws Exception {
            FilePath dir = this.cwd.child(this.step.getPath());
            this.listener.getLogger().println("Running in " + dir);
            this.body = this.getContext().newBodyInvoker().withContext((Object)dir).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
            return false;
        }

        public void stop(Throwable cause) throws Exception {
            if (this.body != null) {
                this.body.cancel(cause);
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "dir";
        }

        public String getDisplayName() {
            return "Change current directory";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<Class<?>> getProvidedContext() {
            return ImmutableSet.of(FilePath.class);
        }
    }
}

