/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class ReadFileStep
extends AbstractStepImpl {
    private final String file;
    private String encoding;

    @DataBoundConstructor
    public ReadFileStep(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = Util.fixEmptyAndTrim((String)encoding);
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<String> {
        @Inject
        private transient ReadFileStep step;
        @StepContextParameter
        private transient FilePath workspace;
        private static final long serialVersionUID = 1L;

        protected String run() throws Exception {
            try (InputStream is = this.workspace.child(this.step.file).read();){
                String string = IOUtils.toString((InputStream)is, (String)this.step.encoding);
                return string;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "readFile";
        }

        public String getDisplayName() {
            return "Read file from workspace";
        }
    }
}

