/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jenkins.model.CauseOfInterruption;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.TimeoutStep;

@SuppressFBWarnings(value={"SE_INNER_CLASS"})
public class TimeoutStepExecution
extends AbstractStepExecutionImpl {
    @Inject(optional=true)
    private transient TimeoutStep step;
    private BodyExecution body;
    private transient ScheduledFuture<?> killer;
    private long end = 0L;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        StepContext context = this.getContext();
        this.body = context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback()).start();
        long now = System.currentTimeMillis();
        this.end = now + this.step.getUnit().toMillis(this.step.getTime());
        this.setupTimer(now);
        return false;
    }

    public void onResume() {
        super.onResume();
        this.setupTimer(System.currentTimeMillis());
    }

    private void setupTimer(long now) {
        if (this.end > now) {
            this.killer = Timer.get().schedule(new Runnable(){

                @Override
                public void run() {
                    TimeoutStepExecution.this.body.cancel(new CauseOfInterruption[]{new ExceededTimeout()});
                }
            }, this.end - now, TimeUnit.MILLISECONDS);
        } else {
            this.body.cancel(new CauseOfInterruption[]{new ExceededTimeout()});
        }
    }

    public void stop(Throwable cause) throws Exception {
        if (this.body != null) {
            this.body.cancel(cause);
        }
    }

    public static final class ExceededTimeout
    extends CauseOfInterruption {
        private static final long serialVersionUID = 1L;

        public String getShortDescription() {
            return "Timeout has been exceeded";
        }
    }

    private class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;

        private Callback() {
        }

        protected void finished(StepContext context) throws Exception {
            if (TimeoutStepExecution.this.killer != null) {
                TimeoutStepExecution.this.killer.cancel(true);
                TimeoutStepExecution.this.killer = null;
            }
        }
    }
}

