/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Run;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.ArtifactManager;
import jenkins.util.VirtualFile;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class ArtifactUnarchiverStepExecution
extends SynchronousNonBlockingStepExecution<List<FilePath>> {
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
    private final transient Map<String, String> mapping;
    private static final long serialVersionUID = 1L;

    ArtifactUnarchiverStepExecution(Map<String, String> mapping, StepContext context) throws Exception {
        super(context);
        if (mapping == null) {
            throw new AbortException("'mapping' has not been defined for this 'unarchive' step");
        }
        this.mapping = mapping;
    }

    protected List<FilePath> run() throws Exception {
        Run r = (Run)this.getContext().get(Run.class);
        ArtifactManager am = r.getArtifactManager();
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (Map.Entry<String, String> e : this.mapping.entrySet()) {
            FilePath dst = new FilePath((FilePath)this.getContext().get(FilePath.class), e.getValue());
            String src = e.getKey();
            String[] all = am.root().list(src);
            if (all.length == 0) {
                throw new AbortException("no artifacts to unarchive in " + src);
            }
            if (all.length == 1 && all[0].equals(src)) {
                if (dst.isDirectory()) {
                    dst = dst.child(this.getFileName(all[0]));
                }
                files.add(this.copy(am.root().child(all[0]), dst));
                continue;
            }
            for (String path : all) {
                files.add(this.copy(am.root().child(path), dst.child(path)));
            }
        }
        return files;
    }

    private FilePath copy(VirtualFile src, FilePath dst) throws IOException, InterruptedException {
        try (InputStream in = src.open();){
            dst.copyFrom(in);
        }
        return dst;
    }

    private String getFileName(String s) {
        int idx = s.lastIndexOf(47);
        if (idx >= 0) {
            s = s.substring(idx + 1);
        }
        if ((idx = s.lastIndexOf(92)) >= 0) {
            s = s.substring(idx + 1);
        }
        return s;
    }
}

