/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public final class CatchErrorStep
extends Step {
    @DataBoundConstructor
    public CatchErrorStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context);
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;

        Execution(StepContext context) {
            super(context);
        }

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback()).start();
            return false;
        }

        public void stop(Throwable cause) throws Exception {
        }

        public void onResume() {
        }

        private static final class Callback
        extends BodyExecutionCallback {
            private Callback() {
            }

            public void onSuccess(StepContext context, Object result) {
                context.onSuccess(null);
            }

            public void onFailure(StepContext context, Throwable t) {
                try {
                    TaskListener listener = (TaskListener)context.get(TaskListener.class);
                    Result r = Result.FAILURE;
                    if (t instanceof AbortException) {
                        listener.error(t.getMessage());
                    } else if (t instanceof FlowInterruptedException) {
                        FlowInterruptedException fie = (FlowInterruptedException)t;
                        fie.handle((Run)context.get(Run.class), listener);
                        r = fie.getResult();
                    } else {
                        listener.getLogger().println(Functions.printThrowable((Throwable)t).trim());
                    }
                    ((Run)context.get(Run.class)).setResult(r);
                    context.onSuccess(null);
                }
                catch (Exception x) {
                    context.onFailure((Throwable)x);
                }
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "catchError";
        }

        public String getDisplayName() {
            return "Catch error and set build result";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class);
        }
    }
}

