/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.slaves.WorkspaceList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PwdStep
extends Step {
    private boolean tmp;

    @DataBoundConstructor
    public PwdStep() {
    }

    public boolean isTmp() {
        return this.tmp;
    }

    @DataBoundSetter
    public void setTmp(boolean tmp) {
        this.tmp = tmp;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.tmp, context);
    }

    private static FilePath tempDir(FilePath ws) {
        return ws.sibling(ws.getName() + System.getProperty(WorkspaceList.class.getName(), "@") + "tmp");
    }

    public static class Execution
    extends SynchronousStepExecution<String> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient boolean tmp;
        private static final long serialVersionUID = 1L;

        Execution(boolean tmp, StepContext context) {
            super(context);
            this.tmp = tmp;
        }

        protected String run() throws Exception {
            FilePath cwd = (FilePath)this.getContext().get(FilePath.class);
            return (this.tmp ? PwdStep.tempDir(cwd) : cwd).getRemote();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "pwd";
        }

        public String getDisplayName() {
            return "Determine current directory";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            return null;
        }
    }
}

