/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class ReadFileStep
extends Step {
    private final String file;
    private String encoding;

    @DataBoundConstructor
    public ReadFileStep(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = Util.fixEmptyAndTrim((String)encoding);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static final class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        private final transient ReadFileStep step;
        private static final long serialVersionUID = 1L;

        Execution(ReadFileStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            try (InputStream is = ((FilePath)this.getContext().get(FilePath.class)).child(this.step.file).read();){
                String string = IOUtils.toString((InputStream)is, (String)this.step.encoding);
                return string;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "readFile";
        }

        public String getDisplayName() {
            return "Read file from workspace";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }
    }
}

