/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Main;
import hudson.Util;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearBlockHoppingScanner;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.TimeoutStep;

@SuppressFBWarnings(value={"SE_INNER_CLASS"})
public class TimeoutStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(TimeoutStepExecution.class.getName());
    private static final long GRACE_PERIOD = Main.isUnitTest ? 5000L : 60000L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
    private final transient TimeoutStep step;
    private BodyExecution body;
    private transient ScheduledFuture<?> killer;
    private long end = 0L;
    private boolean forcible;
    private static final long serialVersionUID = 1L;

    TimeoutStepExecution(TimeoutStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        StepContext context = this.getContext();
        this.body = context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback()).start();
        long now = System.currentTimeMillis();
        this.end = now + this.step.getUnit().toMillis(this.step.getTime());
        this.setupTimer(now);
        return false;
    }

    public void onResume() {
        this.setupTimer(System.currentTimeMillis());
    }

    private TaskListener listener() {
        try {
            return (TaskListener)this.getContext().get(TaskListener.class);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
            return TaskListener.NULL;
        }
    }

    private void setupTimer(long now) {
        long delay = this.end - now;
        if (delay > 0L) {
            if (!this.forcible) {
                this.listener().getLogger().println("Timeout set to expire in " + Util.getTimeSpanString((long)delay));
            }
            this.killer = Timer.get().schedule(new Runnable(){

                @Override
                public void run() {
                    TimeoutStepExecution.this.cancel();
                }
            }, delay, TimeUnit.MILLISECONDS);
        } else {
            this.listener().getLogger().println("Timeout expired " + Util.getTimeSpanString((long)(-delay)) + " ago");
            this.cancel();
        }
    }

    private void cancel() {
        if (this.forcible) {
            if (!this.killer.isCancelled()) {
                FlowExecution exec;
                this.listener().getLogger().println("Body did not finish within grace period; terminating with extreme prejudice");
                try {
                    exec = (FlowExecution)this.getContext().get(FlowExecution.class);
                }
                catch (IOException | InterruptedException x) {
                    LOGGER.log(Level.WARNING, null, x);
                    return;
                }
                FlowInterruptedException death = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[]{new ExceededTimeout()});
                final ListenableFuture currentExecutions = exec.getCurrentExecutions(true);
                currentExecutions.addListener(new Runnable((Throwable)death){
                    final /* synthetic */ Throwable val$death;
                    {
                        this.val$death = throwable;
                    }

                    @Override
                    public void run() {
                        assert (currentExecutions.isDone());
                        try {
                            FlowNode outer = (FlowNode)TimeoutStepExecution.this.getContext().get(FlowNode.class);
                            block2: for (StepExecution exec : (List)currentExecutions.get()) {
                                FlowNode inner = (FlowNode)exec.getContext().get(FlowNode.class);
                                LinearBlockHoppingScanner scanner = new LinearBlockHoppingScanner();
                                scanner.setup(inner);
                                for (FlowNode enclosing : scanner) {
                                    if (!enclosing.equals((Object)outer)) continue;
                                    exec.getContext().onFailure(this.val$death);
                                    continue block2;
                                }
                            }
                        }
                        catch (IOException | InterruptedException | ExecutionException x) {
                            LOGGER.log(Level.WARNING, null, x);
                        }
                    }
                }, (Executor)MoreExecutors.sameThreadExecutor());
            }
        } else {
            this.listener().getLogger().println("Cancelling nested steps due to timeout");
            this.body.cancel(new CauseOfInterruption[]{new ExceededTimeout()});
            this.forcible = true;
            long now = System.currentTimeMillis();
            this.end = now + GRACE_PERIOD;
            this.setupTimer(now);
        }
    }

    public void stop(Throwable cause) throws Exception {
        if (this.body != null) {
            this.body.cancel(cause);
        }
    }

    public String getStatus() {
        if (this.killer == null) {
            return "killer task nowhere to be found";
        }
        if (this.killer.isCancelled()) {
            return "killer task was cancelled";
        }
        if (this.killer.isDone()) {
            return "killer task reported done";
        }
        long delay = this.end - System.currentTimeMillis();
        if (delay <= 0L) {
            return "overshot by " + Util.getTimeSpanString((long)(-delay));
        }
        String delayS = Util.getTimeSpanString((long)delay);
        if (this.forcible) {
            return "body did not yet respond to signal; forcibly killing in " + delayS;
        }
        return "body has another " + delayS + " to run";
    }

    public static final class ExceededTimeout
    extends CauseOfInterruption {
        private static final long serialVersionUID = 1L;

        public String getShortDescription() {
            return "Timeout has been exceeded";
        }
    }

    private class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;

        private Callback() {
        }

        protected void finished(StepContext context) throws Exception {
            if (TimeoutStepExecution.this.killer != null) {
                TimeoutStepExecution.this.killer.cancel(true);
                TimeoutStepExecution.this.killer = null;
            }
        }
    }
}

