/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.stash;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class StashStep
extends Step {
    @Nonnull
    private final String name;
    @CheckForNull
    private String includes;
    @CheckForNull
    private String excludes;
    private boolean useDefaultExcludes = true;
    private boolean allowEmpty = false;

    @DataBoundConstructor
    public StashStep(@Nonnull String name) {
        Jenkins.checkGoodName((String)name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getIncludes() {
        return this.includes;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = Util.fixEmpty((String)includes);
    }

    public String getExcludes() {
        return this.excludes;
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = Util.fixEmpty((String)excludes);
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    @DataBoundSetter
    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    @DataBoundSetter
    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "stash";
        }

        public String getDisplayName() {
            return "Stash some files to be used later in the build";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, TaskListener.class);
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Object name = namedArgs.get("name");
            return name instanceof String ? (String)name : null;
        }
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient StashStep step;

        Execution(StashStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            StashManager.stash((Run)((Run)this.getContext().get(Run.class)), (String)this.step.name, (FilePath)((FilePath)this.getContext().get(FilePath.class)), (TaskListener)((TaskListener)this.getContext().get(TaskListener.class)), (String)this.step.includes, (String)this.step.excludes, (boolean)this.step.useDefaultExcludes, (boolean)this.step.allowEmpty);
            return null;
        }
    }
}

