/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.stash;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class UnstashStep
extends Step {
    @Nonnull
    private final String name;

    @DataBoundConstructor
    public UnstashStep(@Nonnull String name) {
        Jenkins.checkGoodName((String)name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.name, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "unstash";
        }

        public String getDisplayName() {
            return "Restore files previously stashed";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, TaskListener.class);
        }
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String name;

        Execution(String name, StepContext context) {
            super(context);
            this.name = name;
        }

        protected Void run() throws Exception {
            StashManager.unstash((Run)((Run)this.getContext().get(Run.class)), (String)this.name, (FilePath)((FilePath)this.getContext().get(FilePath.class)), (TaskListener)((TaskListener)this.getContext().get(TaskListener.class)));
            return null;
        }
    }
}

