/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class GlobalLibraries
extends GlobalConfiguration {
    private List<LibraryConfiguration> libraries = new ArrayList<LibraryConfiguration>();

    @Nonnull
    public static GlobalLibraries get() {
        GlobalLibraries instance = (GlobalLibraries)((Object)GlobalConfiguration.all().get(GlobalLibraries.class));
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    public GlobalLibraries() {
        this.load();
    }

    public List<LibraryConfiguration> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<LibraryConfiguration> libraries) {
        this.libraries = libraries;
        this.save();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        if (Jenkins.getActiveInstance().hasPermission(Jenkins.RUN_SCRIPTS)) {
            this.setLibraries(Collections.emptyList());
            req.bindJSON((Object)this, json);
            return true;
        }
        return true;
    }

    @Extension(ordinal=0.0)
    public static class ForJob
    extends LibraryResolver {
        @Override
        public boolean isTrusted() {
            return true;
        }

        @Override
        public Collection<LibraryConfiguration> forJob(Job<?, ?> job, Map<String, String> libraryVersions) {
            return GlobalLibraries.get().getLibraries();
        }

        @Override
        public Collection<LibraryConfiguration> fromConfiguration(StaplerRequest request) {
            return GlobalLibraries.get().getLibraries();
        }
    }
}

