/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.Message;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GroovyShellDecorator;
import org.jenkinsci.plugins.workflow.libs.ClasspathAdder;
import org.jenkinsci.plugins.workflow.libs.Library;
import org.jenkinsci.plugins.workflow.libs.Messages;

@Extension
public class LibraryDecorator
extends GroovyShellDecorator {
    public void customizeImports(CpsFlowExecution execution, ImportCustomizer ic) {
        ic.addImports(new String[]{Library.class.getName()});
    }

    public void configureCompiler(final CpsFlowExecution execution, CompilerConfiguration cc) {
        if (execution == null) {
            return;
        }
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new CompilationCustomizer(CompilePhase.CONVERSION){

            public void call(final SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                final ArrayList<String> libraries = new ArrayList<String>();
                new ClassCodeVisitorSupport(){

                    protected SourceUnit getSourceUnit() {
                        return source;
                    }

                    public void visitAnnotations(AnnotatedNode node) {
                        super.visitAnnotations(node);
                        for (AnnotationNode annotationNode : node.getAnnotations()) {
                            String name = annotationNode.getClassNode().getName();
                            if (!name.equals(Library.class.getCanonicalName()) && !name.equals(Library.class.getSimpleName())) continue;
                            Expression value = annotationNode.getMember("value");
                            if (value instanceof ConstantExpression) {
                                libraries.add((String)((ConstantExpression)value).getValue());
                                continue;
                            }
                            for (Expression element : ((ListExpression)value).getExpressions()) {
                                libraries.add((String)((ConstantExpression)element).getValue());
                            }
                        }
                    }
                }.visitClass(classNode);
                try {
                    for (ClasspathAdder adder : ExtensionList.lookup(ClasspathAdder.class)) {
                        for (ClasspathAdder.Addition addition : adder.add(execution, libraries)) {
                            addition.addTo(execution);
                        }
                    }
                    if (!libraries.isEmpty()) {
                        throw new AbortException(Messages.LibraryDecorator_could_not_find_any_definition_of_librari(libraries));
                    }
                }
                catch (Exception x) {
                    source.getErrorCollector().addErrorAndContinue(Message.create((String)"Loading libraries failed", (ProcessingUnit)source));
                    try {
                        TaskListener listener = execution.getOwner().getListener();
                        if (x instanceof AbortException) {
                            listener.error(x.getMessage());
                        } else {
                            x.printStackTrace(listener.getLogger());
                        }
                        throw new CompilationFailedException(3, (ProcessingUnit)source);
                    }
                    catch (IOException x2) {
                        Logger.getLogger(LibraryDecorator.class.getName()).log(Level.WARNING, null, x2);
                        throw new CompilationFailedException(3, (ProcessingUnit)source, (Throwable)x);
                    }
                }
            }
        }});
    }
}

