/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.global;

import groovy.lang.Binding;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.global.WorkflowLibRepository;

public class UserDefinedGlobalVariable
extends GlobalVariable {
    private final File help;
    private final String name;
    static final String PREFIX = "vars";

    UserDefinedGlobalVariable(WorkflowLibRepository repo, String name) {
        this(name, new File(repo.workspace, "vars/" + name + ".txt"));
    }

    public UserDefinedGlobalVariable(String name, File help) {
        this.name = name;
        this.help = help;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Object getValue(@Nonnull CpsScript script) throws Exception {
        Object instance;
        Binding binding = script.getBinding();
        if (binding.hasVariable(this.getName())) {
            instance = binding.getVariable(this.getName());
        } else {
            CpsThread c = CpsThread.current();
            if (c == null) {
                throw new IllegalStateException("Expected to be called from CpsThread");
            }
            instance = c.getExecution().getShell().getClassLoader().loadClass(this.getName()).newInstance();
            binding.setVariable(this.getName(), instance);
        }
        return instance;
    }

    @CheckForNull
    public String getHelpHtml() throws IOException {
        if (!this.help.exists()) {
            return null;
        }
        return Jenkins.getActiveInstance().getMarkupFormatter().translate(FileUtils.readFileToString((File)this.help, (Charset)Charsets.UTF_8).replace("\r\n", "\n"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UserDefinedGlobalVariable that = (UserDefinedGlobalVariable)((Object)o);
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

