/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import com.google.common.collect.Lists;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.AccessControlled;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AbstractWhitelist;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.libs.LibrariesAction;
import org.jenkinsci.plugins.workflow.libs.LibraryAdder;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRecord;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.LibraryRetrieverDescriptor;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class LibraryStep
extends AbstractStepImpl {
    private static final Logger LOGGER = Logger.getLogger(LibraryStep.class.getName());
    private final String identifier;
    private LibraryRetriever retriever;

    @DataBoundConstructor
    public LibraryStep(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public LibraryRetriever getRetriever() {
        return this.retriever;
    }

    @DataBoundSetter
    public void setRetriever(LibraryRetriever retriever) {
        this.retriever = retriever;
    }

    @Extension
    public static class LoadedClassesWhitelist
    extends AbstractWhitelist {
        public boolean permitsMethod(Method method, Object receiver, Object[] args) {
            String name = method.getName();
            return receiver instanceof LoadedClasses && method.getDeclaringClass() == GroovyObject.class && (name.equals("getProperty") || name.equals("invokeMethod"));
        }
    }

    public static final class LoadedClasses
    extends GroovyObjectSupport
    implements Serializable {
        @Nonnull
        private final String library;
        private final boolean trusted;
        @Nonnull
        private final String prefix;
        @CheckForNull
        private final String clazz;
        @Nonnull
        private final String srcUrl;

        LoadedClasses(String library, boolean trusted, Run<?, ?> run) {
            this(library, trusted, "", null, new File(run.getRootDir(), "libs/" + library + "/src").toURI().toString());
        }

        LoadedClasses(String library, boolean trusted, String prefix, String clazz, String srcUrl) {
            this.library = library;
            this.trusted = trusted;
            this.prefix = prefix;
            this.clazz = clazz;
            this.srcUrl = srcUrl;
        }

        public Object getProperty(String property) {
            if (this.clazz != null) {
                try {
                    return this.loadClass(this.prefix + this.clazz).getField(property).get(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException x) {
                    throw new GroovyRuntimeException((Throwable)x);
                }
            }
            if (property.matches("^[A-Z].*")) {
                String fullClazz = this.clazz != null ? this.clazz + '$' + property : property;
                this.loadClass(this.prefix + fullClazz);
                return new LoadedClasses(this.library, this.trusted, this.prefix, fullClazz, this.srcUrl);
            }
            return new LoadedClasses(this.library, this.trusted, this.prefix + property + '.', null, this.srcUrl);
        }

        public Object invokeMethod(String name, Object _args) {
            Object[] objectArray;
            Class<?> c = this.loadClass(this.prefix + this.clazz);
            if (_args instanceof Object[]) {
                objectArray = (Object[])_args;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = _args;
            }
            Object[] args = objectArray;
            try {
                if (name.equals("new")) {
                    return ConstructorUtils.invokeConstructor(c, (Object[])args);
                }
                return MethodUtils.invokeStaticMethod(c, (String)name, (Object[])args);
            }
            catch (InvocationTargetException x) {
                throw new GroovyRuntimeException(x.getCause());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException x) {
                throw new GroovyRuntimeException((Throwable)x);
            }
        }

        private Class<?> loadClass(String name) {
            CpsFlowExecution exec = CpsThread.current().getExecution();
            GroovyClassLoader loader = (this.trusted ? exec.getTrustedShell() : exec.getShell()).getClassLoader();
            try {
                String srcUrlC;
                Class c = loader.loadClass(name);
                ClassLoader definingLoader = c.getClassLoader();
                if (definingLoader instanceof GroovyClassLoader.InnerLoader) {
                    definingLoader = definingLoader.getParent();
                }
                if (definingLoader != loader) {
                    throw new IllegalAccessException("cannot access " + c + " via library handle: " + definingLoader + " is not " + loader);
                }
                CodeSource codeSource = c.getProtectionDomain().getCodeSource();
                if (codeSource == null) {
                    throw new IllegalAccessException(name + " had no defined code source");
                }
                String actual = LoadedClasses.canonicalize(codeSource.getLocation().toString());
                if (!actual.startsWith(srcUrlC = LoadedClasses.canonicalize(this.srcUrl))) {
                    throw new IllegalAccessException(name + " was defined in " + actual + " which was not inside " + srcUrlC);
                }
                if (!Modifier.isPublic(c.getModifiers())) {
                    throw new IllegalAccessException(c + " is not public");
                }
                return c;
            }
            catch (ClassNotFoundException | IllegalAccessException x) {
                throw new GroovyRuntimeException((Throwable)x);
            }
        }

        private static String canonicalize(String uri) {
            if (uri.startsWith("file:/")) {
                try {
                    return Paths.get(new URI(uri)).toRealPath(new LinkOption[0]).toUri().toString();
                }
                catch (IOException | URISyntaxException x) {
                    LOGGER.log(Level.WARNING, "could not canonicalize " + uri, x);
                }
            }
            return uri;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<LoadedClasses> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient LibraryStep step;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient TaskListener listener;

        protected LoadedClasses run() throws Exception {
            String[] parsed = LibraryAdder.parse(this.step.identifier);
            String name = parsed[0];
            String version = parsed[1];
            boolean trusted = false;
            LibraryRetriever retriever = this.step.getRetriever();
            if (retriever == null) {
                block0: for (LibraryResolver resolver : ExtensionList.lookup(LibraryResolver.class)) {
                    for (LibraryConfiguration libraryConfiguration : resolver.forJob(this.run.getParent(), Collections.singletonMap(name, version))) {
                        if (!libraryConfiguration.getName().equals(name)) continue;
                        retriever = libraryConfiguration.getRetriever();
                        trusted = resolver.isTrusted();
                        version = libraryConfiguration.defaultedVersion(version);
                        continue block0;
                    }
                }
                if (retriever == null) {
                    throw new AbortException("No library named " + name + " found");
                }
            } else if (version == null) {
                throw new AbortException("Must specify a version for library " + name);
            }
            LibraryRecord record = new LibraryRecord(name, version, trusted);
            LibrariesAction action = (LibrariesAction)this.run.getAction(LibrariesAction.class);
            if (action == null) {
                action = new LibrariesAction(Lists.newArrayList((Object[])new LibraryRecord[]{record}));
                this.run.addAction((Action)action);
            } else {
                List<LibraryRecord> libraries = action.getLibraries();
                for (LibraryRecord existing : libraries) {
                    if (!existing.name.equals(name)) continue;
                    this.listener.getLogger().println("Only using first definition of library " + name);
                    return new LoadedClasses(name, trusted, this.run);
                }
                libraries.add(record);
            }
            this.listener.getLogger().println("Loading library " + record.name + "@" + record.version);
            CpsFlowExecution exec = (CpsFlowExecution)this.getContext().get(FlowExecution.class);
            GroovyClassLoader groovyClassLoader = (trusted ? exec.getTrustedShell() : exec.getShell()).getClassLoader();
            for (URL u : LibraryAdder.retrieve(record.name, record.version, retriever, record.trusted, this.listener, this.run, (CpsFlowExecution)this.getContext().get(FlowExecution.class), record.variables)) {
                groovyClassLoader.addURL(u);
            }
            this.run.save();
            return new LoadedClasses(name, trusted, this.run);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "library";
        }

        public String getDisplayName() {
            return "Load a shared library on the fly";
        }

        @Restricted(value={DoNotUse.class})
        public Collection<LibraryRetrieverDescriptor> getRetrieverDescriptors() {
            return ((LibraryConfiguration.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(LibraryConfiguration.DescriptorImpl.class)).getRetrieverDescriptors();
        }

        public AutoCompletionCandidates doAutoCompleteIdentifier(@AncestorInPath ItemGroup<?> group, @QueryParameter String value) {
            TreeSet<String> names = new TreeSet<String>();
            if (group instanceof AccessControlled && ((AccessControlled)group).hasPermission(Item.EXTENDED_READ)) {
                for (LibraryResolver resolver : ExtensionList.lookup(LibraryResolver.class)) {
                    for (LibraryConfiguration cfg : resolver.suggestedConfigurations(group)) {
                        names.add(cfg.getName());
                    }
                }
            }
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            for (String name : names) {
                if (!name.startsWith(value)) continue;
                candidates.add(name);
            }
            return candidates;
        }
    }
}

