/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.cps.ContextVariableSet;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.SandboxContinuable;
import org.jenkinsci.plugins.workflow.cps.ThreadTask;
import org.jenkinsci.plugins.workflow.cps.ThreadTaskResult;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public final class CpsThread
implements Serializable {
    @Nonnull
    final CpsThreadGroup group;
    public final int id;
    private volatile Continuable program;
    Outcome resumeValue;
    private transient SettableFuture<Object> promise;
    final FlowHead head;
    @Nullable
    private final ContextVariableSet contextVariables;
    private StepExecution step;
    private final List<FutureCallback<Object>> completionHandlers = new ArrayList<FutureCallback<Object>>();
    private static final Logger LOGGER = Logger.getLogger(CpsThread.class.getName());
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<CpsThread> CURRENT = new ThreadLocal();

    CpsThread(CpsThreadGroup group, int id, Continuable program, FlowHead head, ContextVariableSet contextVariables) {
        this.group = group;
        this.id = id;
        this.program = group.getExecution().isSandbox() ? new SandboxContinuable(program, this) : program;
        this.head = head;
        this.contextVariables = contextVariables;
    }

    public CpsThreadGroup getGroup() {
        return this.group;
    }

    public CpsFlowExecution getExecution() {
        return this.group.getExecution();
    }

    <T> T getContextVariable(Class<T> type) {
        if (this.contextVariables == null) {
            return null;
        }
        return this.contextVariables.get(type);
    }

    public ContextVariableSet getContextVariables() {
        return this.contextVariables;
    }

    boolean isRunnable() {
        return this.resumeValue != null;
    }

    public StepExecution getStep() {
        return this.step;
    }

    void setStep(StepExecution step) {
        this.step = step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Outcome runNextChunk() throws IOException {
        Outcome outcome;
        assert (this.program != null);
        CpsThread old = CURRENT.get();
        CURRENT.set(this);
        try {
            LOGGER.log(Level.FINE, "runNextChunk on {0}", this.resumeValue);
            Outcome o = this.resumeValue;
            this.resumeValue = null;
            outcome = this.program.run0(o);
            if (outcome.getAbnormal() != null) {
                LOGGER.log(Level.FINE, "ran and produced error", outcome.getAbnormal());
            } else {
                LOGGER.log(Level.FINE, "ran and produced {0}", outcome);
            }
        }
        finally {
            CURRENT.set(old);
        }
        if (outcome.getNormal() instanceof ThreadTask) {
            ThreadTask sc = (ThreadTask)outcome.getNormal();
            ThreadTaskResult r = sc.eval(this);
            if (r.resume != null) {
                this.resumeValue = r.resume;
            } else {
                outcome = r.suspend;
            }
        }
        if (this.promise != null) {
            block15: {
                if (outcome.isSuccess()) {
                    this.promise.set(outcome.getNormal());
                } else {
                    try {
                        this.promise.setException(outcome.getAbnormal());
                    }
                    catch (Error e) {
                        if (e == outcome.getAbnormal()) break block15;
                        throw e;
                    }
                }
            }
            this.promise = null;
        }
        return outcome;
    }

    boolean isAlive() {
        return this.program.isResumable();
    }

    @CpsVmThreadOnly
    void addCompletionHandler(FutureCallback<Object> h) {
        if (!(h instanceof Serializable)) {
            throw new IllegalArgumentException(h.getClass() + " is not serializable");
        }
        this.completionHandlers.add(h);
    }

    @CpsVmThreadOnly
    void fireCompletionHandlers(Outcome o) {
        for (FutureCallback<Object> h : this.completionHandlers) {
            if (o.isSuccess()) {
                h.onSuccess(o.getNormal());
                continue;
            }
            h.onFailure(o.getAbnormal());
        }
    }

    @CheckForNull
    CpsThread getNextInner() {
        for (CpsThread t : this.group.threads.values()) {
            if (t.id <= this.id || t.head != this.head) continue;
            return t;
        }
        return null;
    }

    public Future<Object> resume(Outcome v) {
        assert (this.resumeValue == null);
        this.resumeValue = v;
        this.promise = SettableFuture.create();
        this.group.scheduleRun();
        return this.promise;
    }

    @CpsVmThreadOnly
    public void stop(Throwable t) {
        StepExecution s = this.getStep();
        if (s == null) {
            Outcome o = new Outcome(null, t);
            if (this.resumeValue == null) {
                this.resume(o);
            } else {
                this.resumeValue = o;
            }
            return;
        }
        try {
            s.stop(t);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to stop " + s, e);
        }
    }

    public List<StackTraceElement> getStackTrace() {
        return this.program.getStackTrace();
    }

    @CpsVmThreadOnly
    public static CpsThread current() {
        return CURRENT.get();
    }

    public String toString() {
        return "Thread #" + this.id + String.format(" @%h", this);
    }
}

