/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.persistence;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import hudson.Extension;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.pickles.PickleFactory;

@Extension
public class IteratorHack
extends PickleFactory {
    private static final Logger LOGGER = Logger.getLogger(IteratorHack.class.getName());
    private static final Set<String> ACCEPTED_TYPES = ImmutableSet.of((Object)"java.util.ArrayList$Itr");

    public Pickle writeReplace(Object object) {
        if (ACCEPTED_TYPES.contains(object.getClass().getName())) {
            return new Replacement(object);
        }
        return null;
    }

    private static class Replacement
    extends Pickle {
        private final Class type;
        private final Map<Class, Map<String, Object>> fields;

        Replacement(Object o) {
            this.type = o.getClass();
            this.fields = new HashMap<Class, Map<String, Object>>();
            ReflectionProvider rp = Jenkins.XSTREAM2.getReflectionProvider();
            rp.visitSerializableFields(o, new ReflectionProvider.Visitor(){

                public void visit(String name, Class type, Class definedIn, Object value) {
                    if (name.equals("expectedModCount")) {
                        LOGGER.log(Level.FINER, "ignoring expectedModCount={0}", value);
                        return;
                    }
                    HashMap<String, Object> fieldsByClass = (HashMap<String, Object>)Replacement.this.fields.get(definedIn);
                    if (fieldsByClass == null) {
                        fieldsByClass = new HashMap<String, Object>();
                        Replacement.this.fields.put(definedIn, fieldsByClass);
                    }
                    fieldsByClass.put(name, value);
                }
            });
            LOGGER.log(Level.FINE, "replacing {0} with {1}", new Object[]{o, this.fields});
        }

        public ListenableFuture<?> rehydrate() {
            ReflectionProvider rp = Jenkins.XSTREAM2.getReflectionProvider();
            Object o = rp.newInstance(this.type);
            for (Map.Entry<Class, Map<String, Object>> entry : this.fields.entrySet()) {
                Class definedIn = entry.getKey();
                for (Map.Entry<String, Object> entry2 : entry.getValue().entrySet()) {
                    String fieldName = entry2.getKey();
                    Object value = entry2.getValue();
                    rp.writeField(o, fieldName, value, definedIn);
                    if (!fieldName.equals("this$0")) continue;
                    try {
                        Field f = AbstractList.class.getDeclaredField("modCount");
                        f.setAccessible(true);
                        int modCount = f.getInt(value);
                        LOGGER.log(Level.FINER, "found a modCount={0}", modCount);
                        rp.writeField(o, "expectedModCount", (Object)modCount, this.type);
                    }
                    catch (Exception x) {
                        return Futures.immediateFailedFuture((Throwable)x);
                    }
                }
            }
            LOGGER.log(Level.FINE, "reconstructed {0}", o);
            return Futures.immediateFuture((Object)o);
        }
    }
}

