/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.replay;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.cps.replay.OriginalLoadedScripts;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

class ReplayFlowFactoryAction
extends InvisibleAction
implements CpsFlowFactoryAction2,
Queue.QueueAction {
    private String replacementMainScript;
    private final Map<String, String> replacementLoadedScripts;
    private final transient boolean sandbox;

    ReplayFlowFactoryAction(@Nonnull String replacementMainScript, @Nonnull Map<String, String> replacementLoadedScripts, boolean sandbox) {
        this.replacementMainScript = replacementMainScript;
        this.replacementLoadedScripts = new HashMap<String, String>(replacementLoadedScripts);
        this.sandbox = sandbox;
    }

    @Override
    public CpsFlowExecution create(FlowDefinition def, FlowExecutionOwner owner, List<? extends Action> actions) throws IOException {
        String script = this.replacementMainScript;
        this.replacementMainScript = null;
        return new CpsFlowExecution(script, this.sandbox, owner);
    }

    public boolean shouldSchedule(List<Action> actions) {
        return true;
    }

    Set<String> replaceableScripts() {
        return ImmutableSet.copyOf(this.replacementLoadedScripts.keySet());
    }

    @CheckForNull
    String replace(String clazz) {
        return this.replacementLoadedScripts.remove(clazz);
    }

    @Extension
    public static class StoredLoadedScripts
    extends OriginalLoadedScripts {
        @Override
        public Map<String, String> loadScripts(CpsFlowExecution execution) {
            return execution.getLoadedScripts();
        }
    }
}

