/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.model.Computer;
import hudson.remoting.SingleLaneExecutorService;
import hudson.security.ACL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import jenkins.util.InterceptingExecutorService;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;

class CpsVmExecutorService
extends InterceptingExecutorService {
    private CpsThreadGroup cpsThreadGroup;
    static ThreadLocal<CpsThreadGroup> CURRENT = new ThreadLocal();
    static ThreadLocal<ClassLoader> ORIGINAL_CONTEXT_CLASS_LOADER = new ThreadLocal();

    public CpsVmExecutorService(CpsThreadGroup cpsThreadGroup) {
        super((ExecutorService)new SingleLaneExecutorService(Computer.threadPoolForRemoting));
        this.cpsThreadGroup = cpsThreadGroup;
    }

    protected Runnable wrap(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                ThreadContext context = CpsVmExecutorService.this.setUp();
                try {
                    r.run();
                }
                finally {
                    CpsVmExecutorService.this.tearDown(context);
                }
            }
        };
    }

    protected <V> Callable<V> wrap(final Callable<V> r) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                ThreadContext context = CpsVmExecutorService.this.setUp();
                try {
                    Object v = r.call();
                    return v;
                }
                finally {
                    CpsVmExecutorService.this.tearDown(context);
                }
            }
        };
    }

    private ThreadContext setUp() {
        CpsFlowExecution execution = this.cpsThreadGroup.getExecution();
        ACL.impersonate((Authentication)execution.getAuthentication());
        CURRENT.set(this.cpsThreadGroup);
        this.cpsThreadGroup.busy = true;
        Thread t = Thread.currentThread();
        ThreadContext context = new ThreadContext(t);
        t.setName("Running " + (Object)((Object)execution));
        assert (this.cpsThreadGroup.getExecution() != null);
        if (this.cpsThreadGroup.getExecution().getShell() != null) {
            assert (this.cpsThreadGroup.getExecution().getShell().getClassLoader() != null);
            t.setContextClassLoader((ClassLoader)this.cpsThreadGroup.getExecution().getShell().getClassLoader());
        }
        return context;
    }

    private void tearDown(ThreadContext context) {
        CURRENT.set(null);
        this.cpsThreadGroup.busy = false;
        context.restore();
    }

    private static class ThreadContext {
        final Thread thread;
        final String name;
        final ClassLoader classLoader;

        ThreadContext(Thread thread) {
            this.thread = thread;
            this.name = thread.getName();
            this.classLoader = thread.getContextClassLoader();
            ORIGINAL_CONTEXT_CLASS_LOADER.set(this.classLoader);
        }

        void restore() {
            this.thread.setName(this.name);
            this.thread.setContextClassLoader(this.classLoader);
            ORIGINAL_CONTEXT_CLASS_LOADER.set(null);
        }
    }
}

