/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Envs;
import com.cloudbees.groovy.cps.Outcome;
import com.cloudbees.groovy.cps.impl.ConstantBlock;
import com.cloudbees.groovy.cps.impl.ThrowBlock;
import com.cloudbees.groovy.cps.sandbox.DefaultInvoker;
import com.cloudbees.groovy.cps.sandbox.Invoker;
import com.cloudbees.groovy.cps.sandbox.SandboxInvoker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.init.Terminator;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.Iterators;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShell;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShellFactory;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadDump;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.RiverReader;
import org.jenkinsci.plugins.workflow.support.storage.FlowNodeStorage;
import org.jenkinsci.plugins.workflow.support.storage.SimpleXStreamFlowNodeStorage;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class CpsFlowExecution
extends FlowExecution {
    private final String script;
    Map<String, String> loadedScripts = new HashMap<String, String>();
    private final boolean sandbox;
    private transient FlowExecutionOwner owner;
    public volatile transient ListenableFuture<CpsThreadGroup> programPromise;
    private volatile transient Collection<ListenableFuture<?>> pickleFutures;
    transient FlowNodeStorage storage;
    @CheckForNull
    private final String user;
    @GuardedBy(value="this")
    Stack<BlockStartNode> startNodes = new Stack();
    @SuppressFBWarnings(value={"IS_FIELD_NOT_GUARDED", "IS2_INCONSISTENT_SYNC"})
    private transient List<String> startNodesSerial;
    @GuardedBy(value="this")
    private NavigableMap<Integer, FlowHead> heads = new TreeMap<Integer, FlowHead>();
    @SuppressFBWarnings(value={"IS_FIELD_NOT_GUARDED", "IS2_INCONSISTENT_SYNC"})
    private transient Map<Integer, String> headsSerial;
    private final AtomicInteger iota = new AtomicInteger();
    private transient List<GraphListener> listeners;
    private Result result = Result.SUCCESS;
    private boolean done;
    private transient CpsGroovyShell shell;
    private transient CpsGroovyShell trusted;
    private transient Class<?> scriptClass;
    final transient List<Action> flowStartNodeActions = new ArrayList<Action>();
    private static final Logger LOGGER = Logger.getLogger(CpsFlowExecution.class.getName());
    static final ThreadLocal<CpsFlowExecution> PROGRAM_STATE_SERIALIZATION = new ThreadLocal();

    @Deprecated
    public CpsFlowExecution(String script, FlowExecutionOwner owner) throws IOException {
        this(script, false, owner);
    }

    public CpsFlowExecution(String script, boolean sandbox, FlowExecutionOwner owner) throws IOException {
        this.owner = owner;
        this.script = script;
        this.sandbox = sandbox;
        this.storage = this.createStorage();
        Authentication auth = Jenkins.getAuthentication();
        this.user = auth.equals(ACL.SYSTEM) ? null : auth.getName();
    }

    private Object readResolve() {
        if (this.loadedScripts == null) {
            this.loadedScripts = new HashMap<String, String>();
        }
        return this;
    }

    public GroovyShell getShell() {
        return this.shell;
    }

    public GroovyShell getTrustedShell() {
        return this.trusted;
    }

    public FlowNodeStorage getStorage() {
        return this.storage;
    }

    public String getScript() {
        return this.script;
    }

    public Map<String, String> getLoadedScripts() {
        return ImmutableMap.copyOf(this.loadedScripts);
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public FlowExecutionOwner getOwner() {
        return this.owner;
    }

    private SimpleXStreamFlowNodeStorage createStorage() throws IOException {
        return new SimpleXStreamFlowNodeStorage((FlowExecution)this, this.getStorageDir());
    }

    public File getStorageDir() throws IOException {
        return new File(this.owner.getRootDir(), "workflow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        SettableFuture f;
        final CpsScript s = this.parseScript();
        this.scriptClass = ((Object)((Object)s)).getClass();
        s.$initialize();
        final FlowHead h = new FlowHead(this);
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            this.heads.put(h.getId(), h);
        }
        h.newStartNode(new FlowStartNode((FlowExecution)this, this.iotaStr()));
        final CpsThreadGroup g = new CpsThreadGroup(this);
        g.register((Script)s);
        this.programPromise = f = SettableFuture.create();
        g.runner.submit(new Runnable(){

            @Override
            public void run() {
                CpsThread t = g.addThread(new Continuable((Script)s, this.createInitialEnv()), h, null);
                t.resume(new Outcome(null, null));
                f.set((Object)g);
            }

            private Env createInitialEnv() {
                return Envs.empty((Invoker)(CpsFlowExecution.this.isSandbox() ? new SandboxInvoker() : new DefaultInvoker()));
            }
        });
    }

    private CpsScript parseScript() throws IOException {
        this.trusted = new CpsGroovyShellFactory(this).forTrusted().build();
        this.shell = new CpsGroovyShellFactory(this).withParent(this.trusted).build();
        CpsScript s = (CpsScript)this.shell.reparse("WorkflowScript", this.script);
        for (Map.Entry<String, String> e : this.loadedScripts.entrySet()) {
            this.shell.reparse(e.getKey(), e.getValue());
        }
        s.execution = this;
        return s;
    }

    @Restricted(value={NoExternalUse.class})
    public String iotaStr() {
        return String.valueOf(this.iota());
    }

    @Restricted(value={NoExternalUse.class})
    public int iota() {
        return this.iota.incrementAndGet();
    }

    int approximateNodeCount() {
        return this.iota.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeStorage() throws IOException {
        this.storage = this.createStorage();
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            this.heads = new TreeMap<Integer, FlowHead>();
            for (Map.Entry<Integer, String> entry : this.headsSerial.entrySet()) {
                FlowHead h = new FlowHead(this, entry.getKey());
                h.setForDeserialize(this.storage.getNode(entry.getValue()));
                this.heads.put(h.getId(), h);
            }
            this.headsSerial = null;
            this.startNodes = new Stack();
            for (String id : this.startNodesSerial) {
                this.startNodes.add((BlockStartNode)this.storage.getNode(id));
            }
            this.startNodesSerial = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad(FlowExecutionOwner owner) throws IOException {
        this.owner = owner;
        try {
            this.initializeStorage();
            try {
                if (!this.isComplete()) {
                    this.loadProgramAsync(this.getProgramDataFile());
                }
            }
            catch (IOException e) {
                SettableFuture p;
                this.programPromise = p = SettableFuture.create();
                this.loadProgramFailed(e, (SettableFuture<CpsThreadGroup>)p);
            }
        }
        finally {
            if (this.programPromise == null) {
                this.programPromise = Futures.immediateFailedFuture((Throwable)new IllegalStateException("completed or broken execution"));
            }
        }
    }

    public void loadProgramAsync(File programDataFile) {
        SettableFuture result;
        this.programPromise = result = SettableFuture.create();
        try {
            this.scriptClass = ((Object)((Object)this.parseScript())).getClass();
            final RiverReader r = new RiverReader(programDataFile, this.scriptClass.getClassLoader(), this.owner);
            this.pickleFutures = new ArrayList();
            Futures.addCallback((ListenableFuture)r.restorePickles(this.pickleFutures), (FutureCallback)new FutureCallback<Unmarshaller>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(Unmarshaller u) {
                    CpsFlowExecution.this.pickleFutures = null;
                    try {
                        CpsFlowExecution old = PROGRAM_STATE_SERIALIZATION.get();
                        PROGRAM_STATE_SERIALIZATION.set(CpsFlowExecution.this);
                        try {
                            CpsThreadGroup g = (CpsThreadGroup)u.readObject();
                            result.set((Object)g);
                            try {
                                if (g.isPaused()) {
                                    CpsFlowExecution.this.owner.getListener().getLogger().println("Still paused");
                                } else {
                                    CpsFlowExecution.this.owner.getListener().getLogger().println("Ready to run at " + new Date());
                                    g.scheduleRun();
                                }
                            }
                            catch (IOException x) {
                                LOGGER.log(Level.WARNING, null, x);
                            }
                            PROGRAM_STATE_SERIALIZATION.set(old);
                        }
                        catch (Throwable t) {
                            try {
                                this.onFailure(t);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                PROGRAM_STATE_SERIALIZATION.set(old);
                            }
                        }
                    }
                    finally {
                        r.close();
                    }
                }

                public void onFailure(Throwable t) {
                    try {
                        CpsFlowExecution.this.loadProgramFailed(t, (SettableFuture<CpsThreadGroup>)result);
                    }
                    finally {
                        r.close();
                    }
                }
            });
        }
        catch (IOException e) {
            this.loadProgramFailed(e, (SettableFuture<CpsThreadGroup>)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProgramFailed(final Throwable problem, SettableFuture<CpsThreadGroup> promise) {
        FlowHead head;
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            head = this.heads.isEmpty() ? null : this.getFirstHead();
        }
        if (head == null) {
            head = new FlowHead(this);
            try {
                head.newStartNode(new FlowStartNode((FlowExecution)this, this.iotaStr()));
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to persist", e);
            }
        }
        CpsThreadGroup g = new CpsThreadGroup(this);
        final FlowHead head_ = head;
        promise.set((Object)g);
        this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                CpsThread t = g.addThread(new Continuable((Block)new ThrowBlock((Block)new ConstantBlock((Object)(problem instanceof AbortException ? problem : new IOException("Failed to load build state", problem))))), head_, null);
                t.resume(new Outcome(null, null));
            }

            public void onFailure(Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to set program failure on " + CpsFlowExecution.this.owner, t);
                CpsFlowExecution.this.onProgramEnd(new Outcome(null, t));
                CpsFlowExecution.this.cleanUpHeap();
            }
        });
    }

    File getProgramDataFile() throws IOException {
        return new File(this.owner.getRootDir(), "program.dat");
    }

    void runInCpsVmThread(final FutureCallback<CpsThreadGroup> callback) {
        if (this.programPromise == null) {
            throw new IllegalStateException("build storage unloadable, or build already finished");
        }
        Futures.addCallback(this.programPromise, (FutureCallback)new FutureCallback<CpsThreadGroup>(){
            final Exception source = new Exception();

            public void onSuccess(final CpsThreadGroup g) {
                g.runner.submit(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess((Object)g);
                    }
                });
            }

            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }
        });
    }

    public boolean blocksRestart() {
        CpsThreadGroup g;
        if (this.programPromise == null || !this.programPromise.isDone()) {
            return true;
        }
        try {
            g = (CpsThreadGroup)this.programPromise.get();
        }
        catch (Exception x) {
            return true;
        }
        return g.busy;
    }

    public void waitForSuspension() throws InterruptedException, ExecutionException {
        if (this.programPromise == null) {
            return;
        }
        CpsThreadGroup g = (CpsThreadGroup)this.programPromise.get();
        g.scheduleRun().get();
    }

    public synchronized FlowHead getFlowHead(int id) {
        return (FlowHead)this.heads.get(id);
    }

    public synchronized List<FlowNode> getCurrentHeads() {
        ArrayList<FlowNode> r = new ArrayList<FlowNode>();
        if (this.heads == null) {
            LOGGER.log(Level.WARNING, "List of flow heads unset for {0}, perhaps due to broken storage", (Object)this);
            return r;
        }
        for (FlowHead h : this.heads.values()) {
            r.add(h.get());
        }
        return r;
    }

    public ListenableFuture<List<StepExecution>> getCurrentExecutions(final boolean innerMostOnly) {
        if (this.programPromise == null || this.isComplete()) {
            return Futures.immediateFuture(Collections.emptyList());
        }
        final SettableFuture r = SettableFuture.create();
        this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                if (innerMostOnly) {
                    LinkedHashMap<FlowHead, StepExecution> m = new LinkedHashMap<FlowHead, StepExecution>();
                    for (CpsThread t : g.threads.values()) {
                        StepExecution e = t.getStep();
                        if (e == null) continue;
                        m.put(t.head, e);
                    }
                    r.set((Object)ImmutableList.copyOf(m.values()));
                } else {
                    ArrayList<StepExecution> es = new ArrayList<StepExecution>();
                    for (CpsThread t : g.threads.values()) {
                        StepExecution e = t.getStep();
                        if (e == null) continue;
                        es.add(e);
                    }
                    r.set(Collections.unmodifiableList(es));
                }
            }

            public void onFailure(Throwable t) {
                r.setException(t);
            }
        });
        return r;
    }

    public CpsThreadDump getThreadDump() {
        if (this.programPromise == null || this.isComplete()) {
            return CpsThreadDump.EMPTY;
        }
        if (!this.programPromise.isDone()) {
            Collection<ListenableFuture<?>> _pickleFutures = this.pickleFutures;
            if (_pickleFutures != null) {
                StringBuilder b = new StringBuilder("Program is not yet loaded");
                for (ListenableFuture<?> pickleFuture : _pickleFutures) {
                    b.append("\n\t").append(pickleFuture);
                    if (pickleFuture.isCancelled()) {
                        b.append(" (cancelled)");
                    }
                    if (!pickleFuture.isDone()) continue;
                    b.append(" (complete)");
                }
                return CpsThreadDump.fromText(b.toString());
            }
            return CpsThreadDump.fromText("Program state is unknown");
        }
        try {
            return ((CpsThreadGroup)this.programPromise.get()).getThreadDump();
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
        catch (ExecutionException e) {
            return CpsThreadDump.from(new Exception("Failed to resurrect program state", e));
        }
    }

    public synchronized boolean isCurrentHead(FlowNode n) {
        for (FlowHead h : this.heads.values()) {
            if (!h.get().equals((Object)n)) continue;
            return true;
        }
        return false;
    }

    synchronized void addHead(FlowHead h) {
        this.heads.put(h.getId(), h);
    }

    synchronized void removeHead(FlowHead h) {
        this.heads.remove(h.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subsumeHead(FlowNode n) {
        ArrayList _heads;
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            _heads = new ArrayList(this.heads.values());
        }
        for (FlowHead h : _heads) {
            if (h.get() != n) continue;
            h.remove();
            return;
        }
    }

    public void addListener(GraphListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<GraphListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(GraphListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void interrupt(Result result, CauseOfInterruption ... causes) throws IOException, InterruptedException {
        this.setResult(result);
        LOGGER.log(Level.FINE, "Interrupting {0} as {1}", new Object[]{this.owner, result});
        final FlowInterruptedException ex = new FlowInterruptedException(result, causes);
        this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                LinkedHashMap<FlowHead, CpsThread> m = new LinkedHashMap<FlowHead, CpsThread>();
                for (CpsThread t : g.threads.values()) {
                    m.put(t.head, t);
                }
                for (CpsThread t : Iterators.reverse((List)ImmutableList.copyOf(m.values()))) {
                    try {
                        t.stop((Throwable)ex);
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, "Failed to abort " + CpsFlowExecution.this.owner, x);
                    }
                }
            }

            public void onFailure(Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to interrupt steps in " + CpsFlowExecution.this.owner, t);
            }
        });
        Collection<ListenableFuture<?>> futures = this.pickleFutures;
        if (futures != null) {
            LOGGER.log(Level.FINE, "We are still rehydrating pickles in {0}", this.owner);
            for (ListenableFuture<?> future : futures) {
                if (future.isDone()) continue;
                LOGGER.log(Level.FINE, "Trying to cancel {0} for {1}", new Object[]{future, this.owner});
                if (future.cancel(true)) continue;
                LOGGER.log(Level.WARNING, "Failed to cancel {0} for {1}", new Object[]{future, this.owner});
            }
        }
    }

    public FlowNode getNode(String id) throws IOException {
        return this.storage.getNode(id);
    }

    public void setResult(Result v) {
        this.result = this.result.combine(v);
    }

    public Result getResult() {
        return this.result;
    }

    public List<Action> loadActions(FlowNode node) throws IOException {
        return this.storage.loadActions(node);
    }

    public void saveActions(FlowNode node, List<Action> actions) throws IOException {
        this.storage.saveActions(node, actions);
    }

    public boolean isComplete() {
        return this.done || super.isComplete();
    }

    synchronized void onProgramEnd(Outcome outcome) {
        FlowEndNode head = new FlowEndNode((FlowExecution)this, this.iotaStr(), (FlowStartNode)this.startNodes.pop(), this.result, this.getCurrentHeads().toArray(new FlowNode[0]));
        if (outcome.isFailure()) {
            head.addAction((Action)new ErrorAction(outcome.getAbnormal()));
        }
        this.done = true;
        FlowHead first = this.getFirstHead();
        first.setNewHead((FlowNode)head);
        this.heads.clear();
        this.heads.put(first.getId(), first);
    }

    void cleanUpHeap() {
        this.shell = null;
        this.trusted = null;
        if (this.scriptClass != null) {
            ClassLoader loader = this.scriptClass.getClassLoader();
            SerializableClassRegistry.getInstance().release(loader);
            Introspector.flushFromCaches(this.scriptClass);
            try {
                this.cleanUpGlobalClassValue(loader);
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to clean up memory from " + this.owner, x);
            }
            this.scriptClass = null;
        }
    }

    private void cleanUpGlobalClassValue(@Nonnull ClassLoader loader) throws Exception {
        Field globalClassValueF;
        Class<?> classInfoC = Class.forName("org.codehaus.groovy.reflection.ClassInfo");
        try {
            globalClassValueF = classInfoC.getDeclaredField("globalClassValue");
        }
        catch (NoSuchFieldException x) {
            return;
        }
        globalClassValueF.setAccessible(true);
        Object globalClassValue = globalClassValueF.get(null);
        Class<?> groovyClassValuePreJava7C = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7");
        if (!groovyClassValuePreJava7C.isInstance(globalClassValue)) {
            return;
        }
        Field mapF = groovyClassValuePreJava7C.getDeclaredField("map");
        mapF.setAccessible(true);
        Object map = mapF.get(globalClassValue);
        Class<?> groovyClassValuePreJava7Map = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7$GroovyClassValuePreJava7Map");
        Collection entries = (Collection)groovyClassValuePreJava7Map.getMethod("values", new Class[0]).invoke(map, new Object[0]);
        Field klazzF = classInfoC.getDeclaredField("klazz");
        klazzF.setAccessible(true);
        Method removeM = groovyClassValuePreJava7Map.getMethod("remove", Object.class);
        Class<?> entryC = Class.forName("org.codehaus.groovy.util.AbstractConcurrentMapBase$Entry");
        Method getValueM = entryC.getMethod("getValue", new Class[0]);
        ArrayList<Class> toRemove = new ArrayList<Class>();
        for (Object entry : entries) {
            Object value = getValueM.invoke(entry, new Object[0]);
            Class klazz = (Class)klazzF.get(value);
            ClassLoader encounteredLoader = klazz.getClassLoader();
            if (encounteredLoader == loader) {
                toRemove.add(klazz);
                continue;
            }
            LOGGER.log(Level.FINEST, "ignoring {0} with loader {1}", new Object[]{klazz, String.valueOf(encounteredLoader)});
        }
        LOGGER.log(Level.FINE, "cleaning up {0} associated with {1}", new Object[]{((Object)toRemove).toString(), loader.toString()});
        for (Class klazz : toRemove) {
            removeM.invoke(map, klazz);
        }
    }

    synchronized FlowHead getFirstHead() {
        assert (!this.heads.isEmpty());
        return this.heads.firstEntry().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(List<FlowNode> nodes, boolean synchronous) {
        if (this.listeners != null) {
            Saveable s = Saveable.NOOP;
            try {
                Queue.Executable exec = this.owner.getExecutable();
                if (exec instanceof Saveable) {
                    s = (Saveable)exec;
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to notify listeners of changes to " + nodes + " in " + (Object)((Object)this), x);
            }
            BulkChange bc = new BulkChange(s);
            try {
                for (FlowNode node : nodes) {
                    for (GraphListener listener : this.listeners) {
                        if (listener instanceof GraphListener.Synchronous != synchronous) continue;
                        listener.onNewHead(node);
                    }
                }
            }
            finally {
                if (synchronous) {
                    bc.abort();
                } else {
                    try {
                        bc.commit();
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }
        }
    }

    public Authentication getAuthentication() {
        if (this.user == null) {
            return ACL.SYSTEM;
        }
        try {
            return User.get((String)this.user).impersonate();
        }
        catch (UsernameNotFoundException x) {
            LOGGER.log(Level.WARNING, "could not restore authentication", x);
            return Jenkins.ANONYMOUS;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public String getNextScriptName(String path) {
        return this.shell.generateScriptName().replaceFirst("[.]groovy$", "");
    }

    public boolean isPaused() {
        if (this.programPromise.isDone()) {
            try {
                return ((CpsThreadGroup)this.programPromise.get()).isPaused();
            }
            catch (InterruptedException | ExecutionException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
        return false;
    }

    public void pause(final boolean v) throws IOException {
        Queue.Executable executable = this.owner.getExecutable();
        if (executable instanceof AccessControlled) {
            ((AccessControlled)executable).checkPermission(Item.CANCEL);
        }
        Futures.addCallback(this.programPromise, (FutureCallback)new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                if (v) {
                    g.pause();
                } else {
                    g.unpause();
                }
                try {
                    CpsFlowExecution.this.owner.getListener().getLogger().println(v ? "Pausing" : "Resuming");
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }

            public void onFailure(Throwable x) {
                LOGGER.log(Level.WARNING, "cannot pause/unpause " + this, x);
            }
        });
    }

    public String toString() {
        return "CpsFlowExecution[" + this.owner + "]";
    }

    @Terminator
    @Restricted(value={DoNotUse.class})
    public static void suspendAll() throws Exception {
        ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, Exception>(){

            public Void call() throws Exception {
                LOGGER.fine("starting to suspend all executions");
                for (FlowExecution execution : FlowExecutionList.get()) {
                    if (!(execution instanceof CpsFlowExecution)) continue;
                    LOGGER.log(Level.FINE, "waiting to suspend {0}", execution);
                    CpsFlowExecution exec = (CpsFlowExecution)execution;
                    if (exec.programPromise == null) continue;
                    ((CpsThreadGroup)exec.programPromise.get(1L, TimeUnit.MINUTES)).scheduleRun().get(1L, TimeUnit.MINUTES);
                }
                LOGGER.fine("finished suspending all executions");
                return null;
            }
        });
    }

    public static final class ConverterImpl
    implements Converter {
        private final ReflectionProvider ref;
        private final Mapper mapper;

        public ConverterImpl(XStream xs) {
            this.ref = xs.getReflectionProvider();
            this.mapper = xs.getMapper();
        }

        public boolean canConvert(Class type) {
            return CpsFlowExecution.class == type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void marshal(Object source, HierarchicalStreamWriter w, MarshallingContext context) {
            CpsFlowExecution e = (CpsFlowExecution)((Object)source);
            this.writeChild(w, context, "result", e.result, Result.class);
            this.writeChild(w, context, "script", e.script, String.class);
            this.writeChild(w, context, "loadedScripts", e.loadedScripts, Map.class);
            this.writeChild(w, context, "sandbox", e.sandbox, Boolean.class);
            if (e.user != null) {
                this.writeChild(w, context, "user", e.user, String.class);
            }
            this.writeChild(w, context, "iota", e.iota.get(), Integer.class);
            CpsFlowExecution cpsFlowExecution = e;
            synchronized (cpsFlowExecution) {
                for (FlowHead h : e.heads.values()) {
                    this.writeChild(w, context, "head", h.getId() + ":" + h.get().getId(), String.class);
                }
                for (BlockStartNode st : e.startNodes) {
                    this.writeChild(w, context, "start", st.getId(), String.class);
                }
            }
        }

        private <T> void writeChild(HierarchicalStreamWriter w, MarshallingContext context, String name, T v, Class<T> staticType) {
            if (!this.mapper.shouldSerializeMember(CpsFlowExecution.class, name)) {
                return;
            }
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)w, (String)name, staticType);
            Class<?> actualType = v.getClass();
            if (actualType != staticType) {
                w.addAttribute(this.mapper.aliasForSystemAttribute("class"), this.mapper.serializedClass(actualType));
            }
            context.convertAnother(v);
            w.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            CpsFlowExecution result = context.currentObject() != null ? (CpsFlowExecution)((Object)context.currentObject()) : (CpsFlowExecution)((Object)this.ref.newInstance(CpsFlowExecution.class));
            result.startNodesSerial = new ArrayList();
            result.headsSerial = new TreeMap();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String nodeName = reader.getNodeName();
                if (nodeName.equals("result")) {
                    Result r = this.readChild(reader, context, Result.class, (Object)result);
                    this.setField(result, "result", r);
                } else if (nodeName.equals("script")) {
                    String script = this.readChild(reader, context, String.class, (Object)result);
                    this.setField(result, "script", script);
                } else if (nodeName.equals("loadedScripts")) {
                    Map loadedScripts = this.readChild(reader, context, Map.class, (Object)result);
                    this.setField(result, "loadedScripts", loadedScripts);
                } else if (nodeName.equals("sandbox")) {
                    boolean sandbox = this.readChild(reader, context, Boolean.class, (Object)result);
                    this.setField(result, "sandbox", sandbox);
                } else if (nodeName.equals("owner")) {
                    this.readChild(reader, context, Object.class, (Object)result);
                } else if (nodeName.equals("user")) {
                    String user = this.readChild(reader, context, String.class, (Object)result);
                    this.setField(result, "user", user);
                } else if (nodeName.equals("head")) {
                    String[] head = this.readChild(reader, context, String.class, (Object)result).split(":");
                    result.headsSerial.put(Integer.parseInt(head[0]), head[1]);
                } else if (nodeName.equals("iota")) {
                    Integer iota = this.readChild(reader, context, Integer.class, (Object)result);
                    this.setField(result, "iota", new AtomicInteger(iota));
                } else if (nodeName.equals("start")) {
                    String id = this.readChild(reader, context, String.class, (Object)result);
                    result.startNodesSerial.add(id);
                }
                reader.moveUp();
            }
            return result;
        }

        private void setField(CpsFlowExecution result, String fieldName, Object value) {
            this.ref.writeField((Object)result, fieldName, value, CpsFlowExecution.class);
        }

        private <T> T readChild(HierarchicalStreamReader r, UnmarshallingContext context, Class<T> type, Object parent) {
            String classAttribute = r.getAttribute(this.mapper.aliasForAttribute("class"));
            if (classAttribute != null) {
                type = this.mapper.realClass(classAttribute);
            }
            return type.cast(context.convertAnother(parent, type));
        }
    }
}

