/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.replay;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.handlers.GenericItemOptionHandler;
import hudson.model.Job;
import hudson.model.Run;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.workflow.cps.replay.Messages;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Setter;

@Extension
public class ReplayCommand
extends CLICommand {
    @Argument(required=true, index=0, metaVar="JOB", usage="Name of the job to replay.", handler=JobHandler.class)
    public Job<?, ?> job;
    @Option(name="-n", aliases={"--number"}, metaVar="BUILD#", usage="Build to replay, if not the last.")
    public int number;
    @Option(name="-s", aliases={"--script"}, metaVar="SCRIPT", usage="Name of script to edit, such as Script3, if not the main Jenkinsfile.")
    public String script;

    public String getName() {
        return "replay-pipeline";
    }

    public String getShortDescription() {
        return Messages.ReplayCommand_shortDescription();
    }

    protected int run() throws Exception {
        Run run;
        Run run2 = run = this.number == 0 ? this.job.getLastBuild() : this.job.getBuildByNumber(this.number);
        if (run == null) {
            throw new AbortException("No such build");
        }
        ReplayAction action = (ReplayAction)run.getAction(ReplayAction.class);
        if (action == null) {
            throw new AbortException("Not a Pipeline build");
        }
        if (!action.isEnabled()) {
            throw new AbortException("Not authorized to replay builds of this job");
        }
        String text = IOUtils.toString((InputStream)this.stdin);
        if (this.script != null) {
            HashMap<String, String> replacementLoadedScripts = new HashMap<String, String>(action.getOriginalLoadedScripts());
            if (!replacementLoadedScripts.containsKey(this.script)) {
                throw new AbortException("Unrecognized script name among " + replacementLoadedScripts.keySet());
            }
            replacementLoadedScripts.put(this.script, text);
            action.run(action.getOriginalScript(), replacementLoadedScripts);
        } else {
            action.run(text, action.getOriginalLoadedScripts());
        }
        return 0;
    }

    public static class JobHandler
    extends GenericItemOptionHandler<Job> {
        public JobHandler(CmdLineParser parser, OptionDef option, Setter<Job> setter) {
            super(parser, option, setter);
        }

        protected Class<Job> type() {
            return Job.class;
        }
    }
}

