/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinitionValidator;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShell;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class CpsFlowDefinition
extends FlowDefinition {
    private final String script;
    private final boolean sandbox;

    public CpsFlowDefinition(String script) {
        this(script, false);
    }

    @DataBoundConstructor
    public CpsFlowDefinition(String script, boolean sandbox) {
        StaplerRequest req = Stapler.getCurrentRequest();
        this.script = sandbox ? script : ScriptApproval.get().configuring(script, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser().withItemAsKey(req != null ? (Item)req.findAncestorObject(Item.class) : null));
        this.sandbox = sandbox;
    }

    private Object readResolve() {
        if (!this.sandbox) {
            ScriptApproval.get().configuring(this.script, GroovyLanguage.get(), ApprovalContext.create());
        }
        return this;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public CpsFlowExecution create(FlowExecutionOwner handle, Action ... actions) throws IOException {
        return this.create(handle, (TaskListener)StreamTaskListener.fromStderr(), Arrays.asList(actions));
    }

    public CpsFlowExecution create(FlowExecutionOwner owner, TaskListener listener, List<? extends Action> actions) throws IOException {
        for (Action action : actions) {
            if (action instanceof CpsFlowFactoryAction) {
                CpsFlowFactoryAction fa = (CpsFlowFactoryAction)action;
                return fa.create(this, owner, actions);
            }
            if (!(action instanceof CpsFlowFactoryAction2)) continue;
            return ((CpsFlowFactoryAction2)action).create(this, owner, actions);
        }
        return new CpsFlowExecution(this.sandbox ? this.script : ScriptApproval.get().using(this.script, GroovyLanguage.get()), this.sandbox, owner);
    }

    @Extension
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        public String getDisplayName() {
            return "Pipeline script";
        }

        public FormValidation doCheckScript(@QueryParameter String value, @QueryParameter boolean sandbox) {
            Jenkins j = Jenkins.getInstance();
            if (j == null) {
                return FormValidation.ok();
            }
            return sandbox ? FormValidation.ok() : ScriptApproval.get().checking(value, GroovyLanguage.get());
        }

        public JSON doCheckScriptCompile(@QueryParameter String value) {
            Jenkins j = Jenkins.getInstance();
            if (j == null) {
                return CpsFlowDefinitionValidator.CheckStatus.SUCCESS.asJSON();
            }
            try {
                new CpsGroovyShell(null).getClassLoader().parseClass(value);
            }
            catch (CompilationFailedException x) {
                return JSONArray.fromObject((Object)CpsFlowDefinitionValidator.toCheckStatus(x).toArray());
            }
            return CpsFlowDefinitionValidator.CheckStatus.SUCCESS.asJSON();
        }
    }
}

