/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Outcome;
import hudson.model.Action;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;

final class FlowHead
implements Serializable {
    private int id;
    private transient CpsFlowExecution execution;
    private FlowNode head;
    private static final Logger LOGGER = Logger.getLogger(FlowHead.class.getName());
    private static final long serialVersionUID = 1L;

    FlowHead(CpsFlowExecution execution, int id) {
        this.id = id;
        this.execution = execution;
    }

    FlowHead(CpsFlowExecution execution) {
        this(execution, execution.iota());
    }

    public FlowHead fork() {
        FlowHead h = new FlowHead(this.execution);
        h.head = this.head;
        this.execution.addHead(h);
        return h;
    }

    public int getId() {
        return this.id;
    }

    public CpsFlowExecution getExecution() {
        return this.execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newStartNode(FlowStartNode n) throws IOException {
        for (Action a : this.execution.flowStartNodeActions) {
            if (a instanceof FlowNodeAction) {
                ((FlowNodeAction)a).onLoad((FlowNode)n);
            }
            n.addAction(a);
        }
        this.execution.flowStartNodeActions.clear();
        Object object = this.execution;
        synchronized (object) {
            this.head = (FlowNode)this.execution.startNodes.push((BlockStartNode)n);
        }
        this.execution.storage.storeNode(this.head);
    }

    void setNewHead(FlowNode v) {
        try {
            this.head = v;
            this.execution.storage.storeNode(this.head);
            CpsThreadGroup c = CpsThreadGroup.current();
            if (c != null) {
                c.notifyNewHead(v);
            } else {
                this.execution.notifyListeners(Collections.singletonList(v), true);
                this.execution.notifyListeners(Collections.singletonList(v), false);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to record new head: " + v, e);
        }
    }

    FlowNode get() {
        return this.head;
    }

    public void markIfFail(Outcome o) {
        if (o.isFailure()) {
            this.get().addAction((Action)new ErrorAction(o.getAbnormal()));
        }
    }

    void setForDeserialize(FlowNode v) {
        this.head = v;
    }

    void remove() {
        this.getExecution().removeHead(this);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.id);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.id = ois.readInt();
    }

    private Object readResolve() {
        this.execution = CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.get();
        if (this.execution != null) {
            return this.execution.getFlowHead(this.id);
        }
        return this;
    }
}

