/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

class GroovyClassLoaderWhitelist
extends Whitelist {
    private final ClassLoader scriptLoader;

    public GroovyClassLoaderWhitelist(GroovyClassLoader scriptLoader) {
        this.scriptLoader = scriptLoader;
    }

    private boolean permits(Class<?> declaringClass) {
        ClassLoader cl = declaringClass.getClassLoader();
        if (cl instanceof GroovyClassLoader.InnerLoader) {
            return cl.getParent() == this.scriptLoader;
        }
        return cl == this.scriptLoader;
    }

    public boolean permitsMethod(Method method, Object receiver, Object[] args) {
        return this.permits(method.getDeclaringClass());
    }

    public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        return this.permits(constructor.getDeclaringClass());
    }

    public boolean permitsStaticMethod(Method method, Object[] args) {
        return this.permits(method.getDeclaringClass());
    }

    public boolean permitsFieldGet(Field field, Object receiver) {
        return this.permits(field.getDeclaringClass());
    }

    public boolean permitsFieldSet(Field field, Object receiver, Object value) {
        return this.permits(field.getDeclaringClass());
    }

    public boolean permitsStaticFieldGet(Field field) {
        return this.permits(field.getDeclaringClass());
    }

    public boolean permitsStaticFieldSet(Field field, Object value) {
        return this.permits(field.getDeclaringClass());
    }
}

