/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ContextVariableSet
implements Serializable {
    private final ContextVariableSet parent;
    private final List<Object> values = new ArrayList<Object>();
    private static final long serialVersionUID = 1L;

    ContextVariableSet(ContextVariableSet parent) {
        this.parent = parent;
    }

    <T> T get(Class<T> type) {
        ContextVariableSet s = this;
        while (s != null) {
            for (Object v : s.values) {
                if (!type.isInstance(v)) continue;
                return type.cast(v);
            }
            s = s.parent;
        }
        return null;
    }

    public static ContextVariableSet from(ContextVariableSet parent, List<Object> overrides) {
        if (overrides == null || overrides.isEmpty()) {
            return parent;
        }
        ContextVariableSet o = new ContextVariableSet(parent);
        o.values.addAll(overrides);
        return o;
    }
}

