/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.steps;

import com.google.common.util.concurrent.FutureCallback;
import com.google.inject.Inject;
import groovy.lang.Script;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.steps.LoadStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class LoadStepExecution
extends AbstractStepExecutionImpl {
    @StepContextParameter
    private transient FilePath cwd;
    @Inject(optional=true)
    private transient LoadStep step;
    @StepContextParameter
    private transient TaskListener listener;
    private static final long serialVersionUID = 1L;

    public boolean start() throws Exception {
        CpsStepContext cps = (CpsStepContext)this.getContext();
        CpsThread t = CpsThread.current();
        CpsFlowExecution execution = t.getExecution();
        String text = this.cwd.child(this.step.getPath()).readToString();
        for (Replacer replacer : ExtensionList.lookup(Replacer.class)) {
            text = replacer.replace(text, execution, execution.getNextScriptName(this.step.getPath()), this.listener);
        }
        Script script = execution.getShell().parse(text);
        cps.newBodyInvoker(t.getGroup().export(script)).withDisplayName(this.step.getPath()).withCallback(BodyExecutionCallback.wrap((FutureCallback)cps)).start();
        return false;
    }

    public void stop(Throwable cause) throws Exception {
    }

    @Restricted(value={NoExternalUse.class})
    public static interface Replacer
    extends ExtensionPoint {
        @Nonnull
        public String replace(@Nonnull String var1, @Nonnull CpsFlowExecution var2, @Nonnull String var3, @Nonnull TaskListener var4);
    }
}

