/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.steps;

import com.cloudbees.groovy.cps.Outcome;
import groovy.lang.Closure;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.steps.ParallelStepExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class ParallelStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(ParallelStep.class.getName());
    private final boolean failFast;
    final Map<String, Closure> closures;

    public ParallelStep(Map<String, Closure> closures, boolean failFast) {
        this.closures = closures;
        this.failFast = failFast;
    }

    @CpsVmThreadOnly(value="CPS program calls this, which is run by CpsVmThread")
    public StepExecution start(StepContext context) throws Exception {
        return new ParallelStepExecution(this, context);
    }

    boolean isFailFast() {
        return this.failFast;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        private static final String FAIL_FAST_FLAG = "failFast";

        public String getFunctionName() {
            return "parallel";
        }

        public Step newInstance(Map<String, Object> arguments) {
            boolean failFast = false;
            LinkedHashMap<String, Closure> closures = new LinkedHashMap<String, Closure>();
            for (Map.Entry<String, Object> e : arguments.entrySet()) {
                if (e.getValue() instanceof Closure) {
                    closures.put(e.getKey(), (Closure)e.getValue());
                    continue;
                }
                if (FAIL_FAST_FLAG.equals(e.getKey()) && e.getValue() instanceof Boolean) {
                    failFast = (Boolean)e.getValue();
                    continue;
                }
                throw new IllegalArgumentException("Expected a closure or failFast but found " + e.getKey() + "=" + e.getValue());
            }
            return new ParallelStep(closures, failFast);
        }

        public Map<String, Object> defineArguments(Step step) throws UnsupportedOperationException {
            ParallelStep ps = (ParallelStep)step;
            TreeMap<String, Closure> retVal = new TreeMap<String, Closure>(ps.closures);
            if (ps.failFast) {
                retVal.put(FAIL_FAST_FLAG, (Closure)Boolean.TRUE);
            }
            return retVal;
        }

        public Set<Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public boolean takesImplicitBlockArgument() {
            return false;
        }

        public String getDisplayName() {
            return "Execute in parallel";
        }
    }

    private static final class FailFastException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private FailFastException() {
        }
    }

    static class ResultHandler
    implements Serializable {
        private final StepContext context;
        private final ParallelStepExecution stepExecution;
        private final boolean failFast;
        private boolean stopSent = false;
        private AbstractMap.SimpleEntry<String, Throwable> originalFailure = null;
        private final Map<String, Outcome> outcomes = new HashMap<String, Outcome>();
        private static final long serialVersionUID = 1L;

        ResultHandler(StepContext context, ParallelStepExecution parallelStepExecution, boolean failFast) {
            this.context = context;
            this.stepExecution = parallelStepExecution;
            this.failFast = failFast;
        }

        Callback callbackFor(String name) {
            this.outcomes.put(name, null);
            return new Callback(this, name);
        }

        private void stopSent() {
            this.stopSent = true;
        }

        private boolean isStopSent() {
            return this.stopSent;
        }

        private static class Callback
        extends BodyExecutionCallback {
            private final ResultHandler handler;
            private final String name;
            private static final long serialVersionUID = 1L;

            Callback(ResultHandler handler, String name) {
                this.handler = handler;
                this.name = name;
            }

            public void onSuccess(StepContext context, Object result) {
                this.handler.outcomes.put(this.name, new Outcome(result, null));
                this.checkAllDone(false);
            }

            public void onFailure(StepContext context, Throwable t) {
                this.handler.outcomes.put(this.name, new Outcome(null, t));
                try {
                    ((TaskListener)context.get(TaskListener.class)).getLogger().println("Failed in branch " + this.name);
                }
                catch (IOException | InterruptedException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
                if (this.handler.originalFailure == null) {
                    this.handler.originalFailure = new AbstractMap.SimpleEntry<String, Throwable>(this.name, t);
                } else {
                    ((Throwable)this.handler.originalFailure.getValue()).addSuppressed(t);
                }
                this.checkAllDone(true);
            }

            private void checkAllDone(boolean stepFailed) {
                HashMap success = new HashMap();
                for (Map.Entry e : this.handler.outcomes.entrySet()) {
                    Outcome o = (Outcome)e.getValue();
                    if (o == null) {
                        if (stepFailed && this.handler.failFast && !this.handler.isStopSent()) {
                            this.handler.stopSent();
                            try {
                                this.handler.stepExecution.stop(new FailFastException());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    if (o.isFailure()) {
                        if (this.handler.originalFailure != null) continue;
                        this.handler.originalFailure = new AbstractMap.SimpleEntry(e.getKey(), ((Outcome)e.getValue()).getAbnormal());
                        continue;
                    }
                    success.put(e.getKey(), o.getNormal());
                }
                if (this.handler.originalFailure != null) {
                    this.handler.context.onFailure((Throwable)this.handler.originalFailure.getValue());
                } else {
                    this.handler.context.onSuccess(success);
                }
            }
        }
    }
}

