/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.RootAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.lang.model.SourceVersion;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;
import org.jenkinsci.plugins.structs.describable.HeterogeneousObjectType;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.Messages;
import org.jenkinsci.plugins.workflow.cps.SnippetizerLink;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class Snippetizer
implements RootAction,
DescriptorByNameOwner {
    public static final String ACTION_URL = "pipeline-syntax";
    @Restricted(value={NoExternalUse.class})
    public static final String GENERATE_URL = "pipeline-syntax/generateSnippet";
    private static final Logger LOGGER = Logger.getLogger(Snippetizer.class.getName());

    static String step2Groovy(Step s) throws UnsupportedOperationException {
        return Snippetizer.object2Groovy(new StringBuilder(), s, false).toString();
    }

    public static String object2Groovy(Object o) throws UnsupportedOperationException {
        return Snippetizer.object2Groovy(new StringBuilder(), o, false).toString();
    }

    static StringBuilder object2Groovy(StringBuilder b, Object o, boolean nestedExp) throws UnsupportedOperationException {
        if (o == null) {
            return b.append("null");
        }
        Class<?> clazz = o.getClass();
        if (clazz == String.class || clazz == Character.class) {
            String text = String.valueOf(o);
            if (text.contains("\n")) {
                b.append("'''").append(text.replace("\\", "\\\\").replace("'", "\\'")).append("'''");
            } else {
                b.append('\'').append(text.replace("\\", "\\\\").replace("'", "\\'")).append('\'');
            }
            return b;
        }
        if (clazz == Boolean.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Byte.class || clazz == Short.class) {
            return b.append(o);
        }
        if (o instanceof List) {
            return Snippetizer.list2groovy(b, (List)o);
        }
        if (o instanceof Map) {
            return Snippetizer.map2groovy(b, (Map)o);
        }
        if (o instanceof UninstantiatedDescribable) {
            return Snippetizer.ud2groovy(b, (UninstantiatedDescribable)o, false, nestedExp);
        }
        for (StepDescriptor d : StepDescriptor.all()) {
            if (!d.clazz.equals(clazz)) continue;
            Step step = (Step)o;
            UninstantiatedDescribable uninst = d.uninstantiate(step);
            boolean blockArgument = d.takesImplicitBlockArgument();
            if (d.isMetaStep()) {
                DescribableModel m = DescribableModel.of((Class)d.clazz);
                DescribableParameter p = m.getFirstRequiredParameter();
                if (p != null) {
                    Object wrapped = uninst.getArguments().get(p.getName());
                    if (wrapped instanceof UninstantiatedDescribable) {
                        boolean failSimplification = false;
                        UninstantiatedDescribable nested = (UninstantiatedDescribable)wrapped;
                        TreeMap copy = new TreeMap(nested.getArguments());
                        for (Map.Entry e : uninst.getArguments().entrySet()) {
                            if (((String)e.getKey()).equals(p.getName()) || copy.put(e.getKey(), e.getValue()) == null) continue;
                            failSimplification = true;
                        }
                        if (!Snippetizer.canUseMetaStep(nested)) {
                            failSimplification = true;
                        }
                        if (!failSimplification) {
                            UninstantiatedDescribable combined = new UninstantiatedDescribable(nested.getSymbol(), nested.getKlass(), copy);
                            combined.setModel(nested.getModel());
                            return Snippetizer.ud2groovy(b, combined, blockArgument, nestedExp);
                        }
                    }
                } else {
                    LOGGER.log(Level.WARNING, "Buggy meta-step " + d.clazz + " defines no mandatory parameter");
                }
            }
            uninst.setSymbol(d.getFunctionName());
            return Snippetizer.functionCall(b, uninst, blockArgument, nestedExp);
        }
        return b.append("<object of type ").append(clazz.getCanonicalName()).append('>');
    }

    private static boolean canUseMetaStep(UninstantiatedDescribable ud) {
        return Snippetizer.canUseSymbol(ud) && StepDescriptor.metaStepsOf((String)ud.getSymbol()).size() == 1;
    }

    private static StringBuilder list2groovy(StringBuilder b, List<?> o) {
        b.append('[');
        boolean first = true;
        for (Object elt : o) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            Snippetizer.object2Groovy(b, elt, true);
        }
        return b.append(']');
    }

    private static StringBuilder map2groovy(StringBuilder b, Map<?, ?> map) {
        b.append('[');
        Snippetizer.mapWithoutBracket2groovy(b, map);
        return b.append(']');
    }

    private static void mapWithoutBracket2groovy(StringBuilder b, Map<?, ?> map) {
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            Object key = entry.getKey();
            if (key instanceof String && SourceVersion.isName((String)key)) {
                b.append(key);
            } else {
                Snippetizer.object2Groovy(b, key, true);
            }
            b.append(": ");
            Snippetizer.object2Groovy(b, entry.getValue(), true);
        }
    }

    private static StringBuilder ud2groovy(StringBuilder b, UninstantiatedDescribable ud, boolean blockArgument, boolean nested) {
        if (!Snippetizer.canUseSymbol(ud)) {
            return Snippetizer.map2groovy(b, ud.toShallowMap());
        }
        return Snippetizer.functionCall(b, ud, blockArgument, nested);
    }

    private static boolean canUseSymbol(UninstantiatedDescribable ud) {
        if (ud.getSymbol() == null) {
            return false;
        }
        return StepDescriptor.byFunctionName((String)ud.getSymbol()) == null;
    }

    private static StringBuilder functionCall(StringBuilder b, UninstantiatedDescribable ud, boolean blockArgument, boolean nested) {
        Map args = ud.getArguments();
        boolean needParenthesis = blockArgument ^ args.isEmpty() || Snippetizer.isSingleMap(args) || Snippetizer.isSingleList(args) || nested;
        b.append(ud.getSymbol());
        b.append(needParenthesis ? (char)'(' : ' ');
        if (ud.hasSoleRequiredArgument()) {
            Snippetizer.object2Groovy(b, args.values().iterator().next(), true);
        } else {
            Snippetizer.mapWithoutBracket2groovy(b, args);
        }
        if (needParenthesis) {
            b.append(')');
        }
        if (blockArgument) {
            if (!args.isEmpty()) {
                b.append(' ');
            }
            b.append("{\n    // some block\n}");
        }
        return b;
    }

    private static boolean isSingleMap(Map<String, ?> args) {
        if (args.size() != 1) {
            return false;
        }
        Object v = args.values().iterator().next();
        if (v instanceof Map) {
            return true;
        }
        if (v instanceof UninstantiatedDescribable) {
            return !Snippetizer.canUseSymbol((UninstantiatedDescribable)v);
        }
        return false;
    }

    private static boolean isSingleList(Map<String, ?> args) {
        if (args.size() != 1) {
            return false;
        }
        Object v = args.values().iterator().next();
        return v instanceof List;
    }

    public String getUrlName() {
        return ACTION_URL;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public Descriptor getDescriptorByName(String id) {
        return Jenkins.get().getDescriptorByName(id);
    }

    @Restricted(value={NoExternalUse.class})
    public Collection<QuasiDescriptor> getQuasiDescriptors(boolean advanced) {
        TreeSet<QuasiDescriptor> t = new TreeSet<QuasiDescriptor>();
        for (StepDescriptor d : StepDescriptor.all()) {
            DescribableParameter delegate;
            DescribableModel m;
            Collection parameters;
            if (d.isAdvanced() != advanced) continue;
            t.add(new QuasiDescriptor((Descriptor<?>)d));
            if (!d.isMetaStep() || (parameters = (m = DescribableModel.of((Class)d.clazz)).getParameters()).size() != 1 || !(delegate = (DescribableParameter)parameters.iterator().next()).isRequired() || !(delegate.getType() instanceof HeterogeneousObjectType)) continue;
            for (DescribableModel delegateOptionSchema : ((HeterogeneousObjectType)delegate.getType()).getTypes().values()) {
                Class delegateOptionType = delegateOptionSchema.getType();
                Descriptor delegateDescriptor = Jenkins.get().getDescriptorOrDie(delegateOptionType.asSubclass(Describable.class));
                Set symbols = SymbolLookup.getSymbolValue((Object)delegateDescriptor);
                if (symbols.isEmpty()) continue;
                t.add(new QuasiDescriptor(delegateDescriptor));
            }
        }
        return t;
    }

    @Restricted(value={DoNotUse.class})
    public Iterable<GlobalVariable> getGlobalVariables() {
        StaplerRequest req = Stapler.getCurrentRequest();
        return GlobalVariable.forJob(req != null ? (Job)req.findAncestorObject(Job.class) : null);
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doGenerateSnippet(StaplerRequest req, @QueryParameter String json) throws Exception {
        Describable o;
        Class<?> c;
        JSONObject jsonO = JSONObject.fromObject((Object)json);
        Jenkins j = Jenkins.get();
        Descriptor descriptor = j.getDescriptor((c = j.getPluginManager().uberClassLoader.loadClass(jsonO.getString("stapler-class"))).asSubclass(Describable.class));
        if (descriptor == null) {
            return HttpResponses.text((String)("<could not find " + c.getName() + ">"));
        }
        try {
            o = descriptor.newInstance(req, jsonO);
        }
        catch (RuntimeException x) {
            return HttpResponses.text((String)Functions.printThrowable((Throwable)x));
        }
        try {
            Step step = null;
            if (o instanceof Step) {
                step = (Step)o;
            } else {
                for (StepDescriptor d : StepDescriptor.allMeta()) {
                    DescribableModel m;
                    DescribableParameter soleRequiredParameter;
                    if (!d.getMetaStepArgumentType().isInstance(o) || (soleRequiredParameter = (m = DescribableModel.of((Class)d.clazz)).getSoleRequiredParameter()) == null) continue;
                    step = d.newInstance(Collections.singletonMap(soleRequiredParameter.getName(), o));
                    break;
                }
            }
            if (step == null) {
                return HttpResponses.text((String)("Cannot find a step corresponding to " + o.getClass().getName()));
            }
            String groovy = Snippetizer.step2Groovy(step);
            if (descriptor instanceof StepDescriptor && ((StepDescriptor)descriptor).isAdvanced()) {
                String warning = Messages.Snippetizer_this_step_should_not_normally_be_used_in();
                groovy = "// " + warning + "\n" + groovy;
            }
            return HttpResponses.text((String)groovy);
        }
        catch (UnsupportedOperationException x) {
            Logger.getLogger(CpsFlowExecution.class.getName()).log(Level.WARNING, "failed to render " + json, x);
            return HttpResponses.text((String)x.getMessage());
        }
    }

    @Restricted(value={DoNotUse.class})
    @CheckForNull
    public Item getItem(StaplerRequest req) {
        return (Item)req.findAncestorObject(Item.class);
    }

    @Nonnull
    public List<SnippetizerLink> getSnippetizerLinks() {
        return ExtensionList.lookup(SnippetizerLink.class);
    }

    public static class LocalAction
    extends Snippetizer {
        @Override
        public String getDisplayName() {
            return Messages.Pipeline_Syntax();
        }

        public String getIconClassName() {
            return "icon-help";
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class PerJobAdder
    extends TransientActionFactory<Job> {
        public Class<Job> type() {
            return Job.class;
        }

        public Collection<? extends Action> createFor(Job target) {
            if (target.getClass().getName().equals("org.jenkinsci.plugins.workflow.job.WorkflowJob") && target.hasPermission(Item.EXTENDED_READ)) {
                return Collections.singleton(new LocalAction());
            }
            return Collections.emptySet();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class QuasiDescriptor
    implements Comparable<QuasiDescriptor> {
        public final Descriptor<?> real;

        QuasiDescriptor(Descriptor<?> real) {
            this.real = real;
        }

        public String getSymbol() {
            if (this.real instanceof StepDescriptor) {
                return ((StepDescriptor)this.real).getFunctionName();
            }
            Set symbolValues = SymbolLookup.getSymbolValue(this.real);
            if (!symbolValues.isEmpty()) {
                return (String)symbolValues.iterator().next();
            }
            throw new AssertionError((Object)"Symbol present but no values defined.");
        }

        @Override
        public int compareTo(QuasiDescriptor o) {
            return this.getSymbol().compareTo(o.getSymbol());
        }

        public boolean equals(Object obj) {
            return obj instanceof QuasiDescriptor && this.real == ((QuasiDescriptor)obj).real;
        }

        public int hashCode() {
            return this.real.hashCode();
        }

        public String toString() {
            return this.getSymbol() + "=" + this.real.clazz.getSimpleName();
        }
    }
}

