/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.actions;

import com.google.common.collect.Maps;
import groovy.lang.GroovyClassLoader;
import hudson.EnvVars;
import hudson.model.Describable;
import hudson.model.Result;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.io.output.NullOutputStream;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ArgumentsActionImpl
extends ArgumentsAction {
    @CheckForNull
    private Map<String, Object> arguments;
    boolean isUnmodifiedBySanitization = true;
    private static final Logger LOGGER = Logger.getLogger(ArgumentsActionImpl.class.getName());
    private static final HashSet<String> SAFE_ENVIRONMENT_VARIABLES = new HashSet<String>(Arrays.asList("BRANCH_NAME", "BUILD_DISPLAY_NAME", "BUILD_ID", "BUILD_NUMBER", "BUILD_TAG", "BUILD_URL", "CHANGE_AUTHOR", "CHANGE_AUTHOR_DISPLAY_NAME", "CHANGE_AUTHOR_EMAIL", "CHANGE_ID", "CHANGE_TARGET", "CHANGE_TITLE", "CHANGE_URL", "EXECUTOR_NUMBER", "HUDSON_COOKIE", "HUDSON_HOME", "HUDSON_SERVER_COOKIE", "HUDSON_URL", "JENKINS_HOME", "JENKINS_SERVER_COOKIE", "JENKINS_URL", "JOB_BASE_NAME", "JOB_NAME", "JOB_URL", "NODE_LABELS", "NODE_NAME", "STAGE_NAME", "WORKSPACE", "HOME", "LANG", "LOGNAME", "MAIL", "NLSPATH", "PATH", "PWD", "SHELL", "SHLVL", "TERM", "USER", "XFILESEARCHPATH", "ALLUSERSPROFILE", "APPDATA", "CD", "ClientName", "CMDEXTVERSION", "CMDCMDLINE", "CommonProgramFiles", "COMPUTERNAME", "COMSPEC", "DATE", "ERRORLEVEL", "HighestNumaNodeNumber", "HOMEDRIVE", "HOMEPATH", "LOCALAPPDATA", "LOGONSERVER", "NUMBER_OF_PROCESSORS", "OS", "PATHEXT", "PROCESSOR_ARCHITECTURE", "PROCESSOR_ARCHITEW6432", "PROCESSOR_IDENTIFIER", "PROCESSOR_LEVEL", "PROCESSOR_REVISION", "ProgramW6432", "ProgramData", "ProgramFiles", "ProgramFiles (x86)", "PROMPT", "PSModulePath", "Public", "RANDOM", "%SessionName%", "SYSTEMDRIVE", "SYSTEMROOT", "TEMP", "TMP", "TIME", "UserDnsDomain", "USERDOMAIN", "USERDOMAIN_roamingprofile", "USERPROFILE", "WINDIR"));

    public ArgumentsActionImpl(@Nonnull Map<String, Object> stepArguments, @CheckForNull EnvVars env) {
        this.arguments = this.serializationCheck(this.sanitizeMapAndRecordMutation(stepArguments, env));
    }

    public ArgumentsActionImpl(@Nonnull Map<String, Object> stepArguments) {
        this(stepArguments, new EnvVars());
    }

    ArgumentsActionImpl() {
        this.isUnmodifiedBySanitization = false;
        this.arguments = Collections.emptyMap();
    }

    public static boolean isStringSafe(@CheckForNull String input, @CheckForNull EnvVars variables, @Nonnull Set<String> safeEnvVariables) {
        if (input == null || variables == null || variables.size() == 0) {
            return true;
        }
        StringBuilder pattern = new StringBuilder();
        int count = 0;
        for (Map.Entry ent : variables.entrySet()) {
            String val = (String)ent.getValue();
            if (val == null || val.isEmpty() || safeEnvVariables.contains(ent.getKey())) continue;
            if (count > 0) {
                pattern.append('|');
            }
            pattern.append(Pattern.quote(val));
            ++count;
        }
        return count > 0 ? !Pattern.compile(pattern.toString()).matcher(input).find() : true;
    }

    boolean isStorableType(Object ob) {
        if (ob == null) {
            return true;
        }
        if (ob instanceof CharSequence || ob instanceof Number || ob instanceof Boolean || ob instanceof Map || ob instanceof List || ob instanceof UninstantiatedDescribable || ob instanceof URL || ob instanceof Result) {
            return true;
        }
        if (ob instanceof Enum) {
            Class enumClass = ((Enum)ob).getDeclaringClass();
            return !(enumClass.getClassLoader() instanceof GroovyClassLoader);
        }
        Class<?> c = ob.getClass();
        return c.isPrimitive() || c.isArray() && !c.getComponentType().isPrimitive();
    }

    @CheckForNull
    Object sanitizeListAndRecordMutation(@Nonnull List objects, @CheckForNull EnvVars variables) {
        if (ArgumentsActionImpl.isOversized((Object)objects)) {
            this.isUnmodifiedBySanitization = false;
            return ArgumentsAction.NotStoredReason.OVERSIZE_VALUE;
        }
        boolean isMutated = false;
        ArrayList<Object> output = new ArrayList<Object>(objects.size());
        for (Object o : objects) {
            Object modded = this.sanitizeObjectAndRecordMutation(o, variables);
            if (modded != o) {
                output.add(modded);
                isMutated = true;
                continue;
            }
            output.add(o);
        }
        return isMutated ? output : objects;
    }

    @CheckForNull
    Object sanitizeArrayAndRecordMutation(@Nonnull Object[] objects, @CheckForNull EnvVars variables) {
        if (ArgumentsActionImpl.isOversized((Object)objects)) {
            this.isUnmodifiedBySanitization = false;
            return ArgumentsAction.NotStoredReason.OVERSIZE_VALUE;
        }
        List<Object> inputList = Arrays.asList(objects);
        Object sanitized = this.sanitizeListAndRecordMutation(inputList, variables);
        if (sanitized == inputList) {
            return objects;
        }
        if (sanitized instanceof List) {
            return ((List)sanitized).toArray();
        }
        return sanitized;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    Object sanitizeObjectAndRecordMutation(@CheckForNull Object o, @CheckForNull EnvVars vars) {
        Map<String, Object> tempVal = o;
        DescribableModel m = null;
        if (tempVal instanceof Step) {
            m = DescribableModel.of(tempVal.getClass());
            tempVal = ((Step)tempVal).getDescriptor().defineArguments((Step)tempVal);
        } else if (tempVal instanceof UninstantiatedDescribable) {
            tempVal = ((UninstantiatedDescribable)tempVal).toMap();
        } else if (tempVal instanceof Describable) {
            try {
                m = DescribableModel.of(tempVal.getClass());
                tempVal = m.uninstantiate2((Object)o).toMap();
            }
            catch (RuntimeException x) {
                LOGGER.log(Level.FINE, "failed to store " + tempVal, x);
                this.isUnmodifiedBySanitization = false;
                return ArgumentsAction.NotStoredReason.UNSERIALIZABLE;
            }
        }
        if (ArgumentsActionImpl.isOversized((Object)tempVal)) {
            this.isUnmodifiedBySanitization = false;
            return ArgumentsAction.NotStoredReason.OVERSIZE_VALUE;
        }
        if (!this.isStorableType(tempVal)) {
            this.isUnmodifiedBySanitization = false;
            return ArgumentsAction.NotStoredReason.UNSERIALIZABLE;
        }
        Map<String, Object> modded = tempVal;
        if (modded instanceof Map) {
            modded = this.sanitizeMapAndRecordMutation(modded, vars);
        } else if (modded instanceof List) {
            modded = this.sanitizeListAndRecordMutation((List)((Object)modded), vars);
        } else if (modded != null && modded.getClass().isArray()) {
            Class<?> componentType = modded.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                this.isUnmodifiedBySanitization = true;
                return ArgumentsAction.NotStoredReason.UNSERIALIZABLE;
            }
            modded = this.sanitizeArrayAndRecordMutation((Object[])modded, vars);
        } else if (modded instanceof String && vars != null && !vars.isEmpty() && !ArgumentsActionImpl.isStringSafe((String)((Object)modded), vars, SAFE_ENVIRONMENT_VARIABLES)) {
            this.isUnmodifiedBySanitization = false;
            return ArgumentsAction.NotStoredReason.MASKED_VALUE;
        }
        if (modded != tempVal) {
            this.isUnmodifiedBySanitization = false;
            if (o instanceof Describable && !(o instanceof Step)) {
                UninstantiatedDescribable rawUd = m.uninstantiate2(o);
                return new UninstantiatedDescribable(rawUd.getSymbol(), rawUd.getKlass(), (Map)modded);
            }
            if (!(o instanceof UninstantiatedDescribable)) return modded;
            UninstantiatedDescribable ud = (UninstantiatedDescribable)o;
            return new UninstantiatedDescribable(ud.getSymbol(), ud.getKlass(), (Map)modded);
        }
        if (!(o instanceof Describable)) return o;
        if (!(tempVal instanceof Map)) return o;
        return m.uninstantiate2(o);
    }

    Map<String, Object> serializationCheck(@Nonnull Map<String, Object> arguments) {
        boolean isMutated = false;
        HashMap out = Maps.newHashMapWithExpectedSize((int)arguments.size());
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            Object val = entry.getValue();
            try {
                if (!(val == null || val instanceof String || val instanceof Boolean || val instanceof Number || val instanceof ArgumentsAction.NotStoredReason || val instanceof TimeUnit)) {
                    Jenkins.XSTREAM2.toXMLUTF8(entry.getValue(), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                }
                out.put(entry.getKey(), entry.getValue());
            }
            catch (Exception ex) {
                out.put(entry.getKey(), ArgumentsAction.NotStoredReason.UNSERIALIZABLE);
                isMutated = true;
                LOGGER.log(Level.FINE, "Failed to serialize argument " + entry.getKey(), ex);
            }
        }
        if (isMutated) {
            this.isUnmodifiedBySanitization = false;
        }
        return out;
    }

    @Nonnull
    Map<String, Object> sanitizeMapAndRecordMutation(@Nonnull Map<String, Object> mapContents, @CheckForNull EnvVars variables) {
        HashMap output = Maps.newHashMapWithExpectedSize((int)mapContents.size());
        boolean isMutated = false;
        for (Map.Entry<String, Object> param : mapContents.entrySet()) {
            Object modded = this.sanitizeObjectAndRecordMutation(param.getValue(), variables);
            if (modded != param.getValue()) {
                output.put(param.getKey(), modded);
                isMutated = true;
                continue;
            }
            output.put(param.getKey(), param.getValue());
        }
        return isMutated ? output : mapContents;
    }

    static int getMaxRetainedLength() {
        return MAX_RETAINED_LENGTH;
    }

    @Nonnull
    protected Map<String, Object> getArgumentsInternal() {
        return this.arguments == null ? Collections.EMPTY_MAP : this.arguments;
    }

    public boolean isUnmodifiedArguments() {
        return this.isUnmodifiedBySanitization;
    }
}

