/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.nodes;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class StepDescriptorCache
implements ExtensionPoint {
    private final ConcurrentHashMap<String, StepDescriptor> store = new ConcurrentHashMap();

    public static StepDescriptorCache getPublicCache() {
        return (StepDescriptorCache)Jenkins.get().getExtensionList(StepDescriptorCache.class).get(0);
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void invalidateGlobalCache() {
        StepDescriptorCache.getPublicCache().invalidateAll();
    }

    public void invalidateAll() {
        this.store.clear();
    }

    @CheckForNull
    public StepDescriptor getDescriptor(String descriptorId) {
        if (descriptorId == null) {
            return null;
        }
        StepDescriptor v = this.store.get(descriptorId);
        if (v != null) {
            return v;
        }
        Jenkins j = Jenkins.get();
        Descriptor d = j.getDescriptor(descriptorId);
        if (d instanceof StepDescriptor) {
            this.store.put(descriptorId, (StepDescriptor)d);
            return (StepDescriptor)d;
        }
        return null;
    }
}

