/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.steps;

import groovy.lang.Closure;
import hudson.model.Action;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.CpsBodyExecution;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.steps.ParallelStep;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

class ParallelStepExecution
extends StepExecution {
    private transient ParallelStep parallelStep;
    private final List<BodyExecution> bodies = new ArrayList<BodyExecution>();
    private static final long serialVersionUID = 1L;

    public ParallelStepExecution(ParallelStep parallelStep, StepContext context) {
        super(context);
        this.parallelStep = parallelStep;
    }

    public boolean start() throws Exception {
        CpsStepContext cps = (CpsStepContext)this.getContext();
        if (this.parallelStep.closures.isEmpty()) {
            ((TaskListener)cps.get(TaskListener.class)).getLogger().println("No branches to run");
            cps.onSuccess(Collections.emptyMap());
            return true;
        }
        CpsThread t = CpsThread.current();
        ParallelStep.ResultHandler r = new ParallelStep.ResultHandler((StepContext)cps, this, this.parallelStep.isFailFast());
        for (Map.Entry<String, Closure> e : this.parallelStep.closures.entrySet()) {
            CpsBodyExecution body = cps.newBodyInvoker(t.getGroup().export(e.getValue()), true).withStartAction((Action)new ParallelLabelAction(e.getKey())).withCallback(r.callbackFor(e.getKey())).start();
            this.bodies.add(body);
        }
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        for (BodyExecution body : this.bodies) {
            body.cancel(cause);
        }
    }

    private static class ParallelLabelAction
    extends LabelAction
    implements ThreadNameAction {
        private final String branchName;

        ParallelLabelAction(String branchName) {
            super(null);
            this.branchName = branchName;
        }

        public String getDisplayName() {
            return "Branch: " + this.branchName;
        }

        @Nonnull
        public String getThreadName() {
            return this.branchName;
        }
    }
}

