/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import groovy.lang.GroovyObjectSupport;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.RunAction2;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.flow.FlowCopier;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.support.actions.EnvironmentAction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class EnvActionImpl
extends GroovyObjectSupport
implements EnvironmentAction.IncludingOverrides,
Serializable,
RunAction2 {
    private static final Logger LOGGER = Logger.getLogger(EnvActionImpl.class.getName());
    private static final long serialVersionUID = 1L;
    private final Map<String, String> env = new TreeMap<String, String>();
    private transient Run<?, ?> owner;

    private EnvActionImpl() {
    }

    public EnvVars getEnvironment() throws IOException, InterruptedException {
        return this.getEnvironment(this.getListener());
    }

    private TaskListener getListener() throws IOException {
        FlowExecutionOwner executionOwner;
        Object listener = this.owner instanceof FlowExecutionOwner.Executable ? ((executionOwner = ((FlowExecutionOwner.Executable)this.owner).asFlowExecutionOwner()) != null && this.owner.isBuilding() ? executionOwner.getListener() : new LogTaskListener(LOGGER, Level.INFO)) : new LogTaskListener(LOGGER, Level.INFO);
        return listener;
    }

    private EnvVars getEnvironment(TaskListener listener) throws IOException, InterruptedException {
        EnvVars e = this.owner.getEnvironment(listener);
        e.putAll(this.env);
        return e;
    }

    @Exported(name="environment")
    public Map<String, String> getOverriddenEnvironment() {
        return Collections.unmodifiableMap(this.env);
    }

    public String getProperty(String propertyName) {
        try {
            CpsThread t = CpsThread.current();
            TaskListener listener = this.getListener();
            return (String)EnvironmentExpander.getEffectiveEnvironment((EnvVars)this.getEnvironment(listener), (EnvVars)t.getContextVariable(EnvVars.class, this::getExecution, this::getNode), (EnvironmentExpander)t.getContextVariable(EnvironmentExpander.class, this::getExecution, this::getNode), null, (TaskListener)listener).get((Object)propertyName);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
            return null;
        }
    }

    private FlowExecution getExecution() throws IOException {
        if (this.owner instanceof FlowExecutionOwner.Executable) {
            return ((FlowExecutionOwner.Executable)this.owner).asFlowExecutionOwner().get();
        }
        throw new IOException("no FlowExecution");
    }

    private FlowNode getNode() throws IOException {
        throw new IOException("no FlowNode in this context");
    }

    public void setProperty(String propertyName, Object newValue) {
        this.env.put(propertyName, String.valueOf(newValue));
        try {
            this.owner.save();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public void onAttached(Run<?, ?> r) {
        this.owner = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.owner = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EnvActionImpl forRun(@Nonnull Run<?, ?> run) throws IOException {
        Run<?, ?> run2 = run;
        synchronized (run2) {
            EnvActionImpl action = (EnvActionImpl)run.getAction(EnvActionImpl.class);
            if (action == null) {
                action = new EnvActionImpl();
                run.addAction((Action)action);
                run.save();
            }
            return action;
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class Copier
    extends FlowCopier.ByRun {
        public void copy(Run<?, ?> original, Run<?, ?> copy, TaskListener listener) throws IOException, InterruptedException {
            EnvActionImpl orig = (EnvActionImpl)original.getAction(EnvActionImpl.class);
            if (orig != null) {
                EnvActionImpl nue = EnvActionImpl.forRun(copy);
                for (Map.Entry<String, String> entry : orig.getOverriddenEnvironment().entrySet()) {
                    nue.setProperty(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Extension
    public static class Binder
    extends GlobalVariable {
        @Override
        public String getName() {
            return "env";
        }

        @Override
        public EnvActionImpl getValue(CpsScript script) throws Exception {
            Run<?, ?> run = script.$build();
            if (run != null) {
                return EnvActionImpl.forRun(run);
            }
            throw new IllegalStateException("no associated build");
        }

        @Restricted(value={DoNotUse.class})
        public Collection<EnvironmentContributor> getEnvironmentContributors() {
            return EnvironmentContributor.all();
        }
    }
}

