package org.jenkinsci.plugins.workflow.cps;

import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import java.io.NotSerializableException;

/**
 * An exception that replaces Groovy's {@link MultipleCompilationErrorsException},
 * because that is not serializable (which would, under certain circumstances,
 * lead to the user being presented with a {@link NotSerializableException} instead
 * of a compilation error -- see JENKINS-40109).
 */
public class CpsCompilationErrorsException extends RuntimeException {
    public CpsCompilationErrorsException(MultipleCompilationErrorsException original) {
        super(original.getMessage());
        setStackTrace(original.getStackTrace());
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public static final long serialVersionUID = 1;
}
