// CHECKSTYLE:OFF

package org.jenkinsci.plugins.workflow.cps.replay;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ReplayAction.displayName}: {@code Replay}.
     * 
     * @return
     *     {@code Replay}
     */
    public static String ReplayAction_displayName() {
        return holder.format("ReplayAction.displayName");
    }

    /**
     * Key {@code ReplayAction.displayName}: {@code Replay}.
     * 
     * @return
     *     {@code Replay}
     */
    public static Localizable _ReplayAction_displayName() {
        return new Localizable(holder, "ReplayAction.displayName");
    }

    /**
     * Key {@code ReplayCommand.shortDescription}: {@code Replay a Pipeline
     * build with edited script taken from standard input}.
     * 
     * @return
     *     {@code Replay a Pipeline build with edited script taken from standard
     *     input}
     */
    public static String ReplayCommand_shortDescription() {
        return holder.format("ReplayCommand.shortDescription");
    }

    /**
     * Key {@code ReplayCommand.shortDescription}: {@code Replay a Pipeline
     * build with edited script taken from standard input}.
     * 
     * @return
     *     {@code Replay a Pipeline build with edited script taken from standard
     *     input}
     */
    public static Localizable _ReplayCommand_shortDescription() {
        return new Localizable(holder, "ReplayCommand.shortDescription");
    }

    /**
     * Key {@code Replay.permission.description}: {@code Ability to perform a
     * new Pipeline build with an edited script.}.
     * 
     * @return
     *     {@code Ability to perform a new Pipeline build with an edited script.}
     */
    public static String Replay_permission_description() {
        return holder.format("Replay.permission.description");
    }

    /**
     * Key {@code Replay.permission.description}: {@code Ability to perform a
     * new Pipeline build with an edited script.}.
     * 
     * @return
     *     {@code Ability to perform a new Pipeline build with an edited script.}
     */
    public static Localizable _Replay_permission_description() {
        return new Localizable(holder, "Replay.permission.description");
    }

    /**
     * Key {@code ReplayAction.rebuild.displayName}: {@code Rebuild}.
     * 
     * @return
     *     {@code Rebuild}
     */
    public static String ReplayAction_rebuild_displayName() {
        return holder.format("ReplayAction.rebuild.displayName");
    }

    /**
     * Key {@code ReplayAction.rebuild.displayName}: {@code Rebuild}.
     * 
     * @return
     *     {@code Rebuild}
     */
    public static Localizable _ReplayAction_rebuild_displayName() {
        return new Localizable(holder, "ReplayAction.rebuild.displayName");
    }

    /**
     * Key {@code ReplayCause.shortDescription}: {@code Replayed #{0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Replayed #{0}}
     */
    public static String ReplayCause_shortDescription(Object arg0) {
        return holder.format("ReplayCause.shortDescription", arg0);
    }

    /**
     * Key {@code ReplayCause.shortDescription}: {@code Replayed #{0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Replayed #{0}}
     */
    public static Localizable _ReplayCause_shortDescription(Object arg0) {
        return new Localizable(holder, "ReplayCause.shortDescription", arg0);
    }

}
