/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.replay;

import com.cloudbees.diff.Diff;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.TransientActionFactory;
import jenkins.scm.api.SCMRevisionAction;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.replay.Messages;
import org.jenkinsci.plugins.workflow.cps.replay.OriginalLoadedScripts;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayCause;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayFlowFactoryAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ReplayAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(ReplayAction.class.getName());
    private final Run run;
    private static final Iterable<Class<? extends Action>> COPIED_ACTIONS = ImmutableList.of(ParametersAction.class, SCMRevisionAction.class);
    public static final Permission REPLAY = new Permission(Run.PERMISSIONS, "Replay", Messages._Replay_permission_description(), Item.CONFIGURE, PermissionScope.RUN);

    private ReplayAction(Run run) {
        this.run = run;
    }

    public String getDisplayName() {
        return this.isEnabled() ? Messages.ReplayAction_displayName() : Messages.ReplayAction_rebuild_displayName();
    }

    public String getIconFileName() {
        return this.isEnabled() || this.isRebuildEnabled() ? "redo.png" : null;
    }

    public String getUrlName() {
        return this.isEnabled() || this.isRebuildEnabled() ? "replay" : null;
    }

    @CheckForNull
    private CpsFlowExecution getExecutionLazy() {
        FlowExecutionOwner owner = ((FlowExecutionOwner.Executable)this.run).asFlowExecutionOwner();
        if (owner == null) {
            return null;
        }
        FlowExecution exec = owner.getOrNull();
        return exec instanceof CpsFlowExecution ? (CpsFlowExecution)exec : null;
    }

    @CheckForNull
    private CpsFlowExecution getExecutionBlocking() {
        FlowExecutionOwner owner = ((FlowExecutionOwner.Executable)this.run).asFlowExecutionOwner();
        if (owner == null) {
            return null;
        }
        try {
            FlowExecution exec = owner.get();
            return exec instanceof CpsFlowExecution ? (CpsFlowExecution)exec : null;
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error fetching execution for replay", ioe);
            return null;
        }
    }

    public boolean isRebuildEnabled() {
        if (!this.run.hasPermission(Item.BUILD)) {
            return false;
        }
        return this.run.getParent().isBuildable();
    }

    public boolean isEnabled() {
        if (!this.run.hasPermission(REPLAY)) {
            return false;
        }
        if (!this.run.getParent().isBuildable()) {
            return false;
        }
        CpsFlowExecution exec = this.getExecutionLazy();
        if (exec != null) {
            return exec.isSandbox() || Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS);
        }
        return true;
    }

    public boolean isReplayableSandboxTest() {
        CpsFlowExecution exec = this.getExecutionBlocking();
        if (exec != null) {
            if (!exec.isSandbox()) {
                return Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS);
            }
            return true;
        }
        return false;
    }

    public String getOriginalScript() {
        CpsFlowExecution execution = this.getExecutionBlocking();
        return execution != null ? execution.getScript() : "???";
    }

    public Map<String, String> getOriginalLoadedScripts() {
        CpsFlowExecution execution = this.getExecutionBlocking();
        if (execution == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> scripts = new TreeMap<String, String>();
        for (OriginalLoadedScripts replayer : ExtensionList.lookup(OriginalLoadedScripts.class)) {
            scripts.putAll(replayer.loadScripts(execution));
        }
        return scripts;
    }

    public Run getOwner() {
        return this.run;
    }

    @Restricted(value={DoNotUse.class})
    @RequirePOST
    public void doRun(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        if (!this.isEnabled() || !this.isReplayableSandboxTest()) {
            throw new AccessDeniedException("not allowed to replay");
        }
        JSONObject form = req.getSubmittedForm();
        HashMap<String, String> replacementLoadedScripts = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalLoadedScripts().entrySet()) {
            replacementLoadedScripts.put(entry.getKey(), form.optString(entry.getKey().replace('.', '_'), entry.getValue()));
        }
        if (this.run(form.getString("mainScript"), replacementLoadedScripts) == null) {
            throw HttpResponses.error((int)409, (Throwable)new IOException(this.run.getParent().getFullName() + " is not buildable"));
        }
        rsp.sendRedirect("../..");
    }

    @Restricted(value={DoNotUse.class})
    @RequirePOST
    public void doRebuild(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        if (!this.isRebuildEnabled()) {
            throw new AccessDeniedException("not allowed to replay");
        }
        if (this.run(this.getOriginalScript(), this.getOriginalLoadedScripts()) == null) {
            throw HttpResponses.error((int)409, (Throwable)new IOException(this.run.getParent().getFullName() + " is not buildable"));
        }
        rsp.sendRedirect("../..");
    }

    @CheckForNull
    public QueueTaskFuture run(@Nonnull String replacementMainScript, @Nonnull Map<String, String> replacementLoadedScripts) {
        Queue.Item item = this.run2(replacementMainScript, replacementLoadedScripts);
        return item == null ? null : item.getFuture();
    }

    @CheckForNull
    public Queue.Item run2(@Nonnull String replacementMainScript, @Nonnull Map<String, String> replacementLoadedScripts) {
        ArrayList<ReplayFlowFactoryAction> actions = new ArrayList<ReplayFlowFactoryAction>();
        CpsFlowExecution execution = this.getExecutionBlocking();
        if (execution == null) {
            return null;
        }
        actions.add(new ReplayFlowFactoryAction(replacementMainScript, replacementLoadedScripts, execution.isSandbox()));
        actions.add((ReplayFlowFactoryAction)new CauseAction(new Cause[]{new Cause.UserIdCause(), new ReplayCause(this.run)}));
        for (Class<? extends Action> c : COPIED_ACTIONS) {
            actions.addAll(this.run.getActions(c));
        }
        return ParameterizedJobMixIn.scheduleBuild2((Job)this.run.getParent(), (int)0, (Action[])actions.toArray(new Action[actions.size()]));
    }

    @Nonnull
    public static Set<String> replacementsIn(@Nonnull CpsFlowExecution execution) throws IOException {
        Queue.Executable executable = execution.getOwner().getExecutable();
        if (executable instanceof Run) {
            ReplayFlowFactoryAction action = (ReplayFlowFactoryAction)((Run)executable).getAction(ReplayFlowFactoryAction.class);
            if (action != null) {
                return action.replaceableScripts();
            }
            LOGGER.log(Level.FINE, "{0} was not a replay", executable);
        } else {
            LOGGER.log(Level.FINE, "{0} was not a run at all", executable);
        }
        return Collections.emptySet();
    }

    @CheckForNull
    public static String replace(@Nonnull CpsFlowExecution execution, @Nonnull String clazz) throws IOException {
        Queue.Executable executable = execution.getOwner().getExecutable();
        if (executable instanceof Run) {
            ReplayFlowFactoryAction action = (ReplayFlowFactoryAction)((Run)executable).getAction(ReplayFlowFactoryAction.class);
            if (action != null) {
                return action.replace(clazz);
            }
            LOGGER.log(Level.FINE, "{0} was not a replay", executable);
        } else {
            LOGGER.log(Level.FINE, "{0} was not a run at all", executable);
        }
        return null;
    }

    public String getDiff() {
        Run<?, ?> earlier;
        ReplayCause cause;
        Run<?, ?> original = this.run;
        while ((cause = (ReplayCause)original.getCause(ReplayCause.class)) != null && (earlier = cause.getOriginal()) != null) {
            original = earlier;
        }
        ReplayAction originalAction = (ReplayAction)original.getAction(ReplayAction.class);
        if (originalAction == null) {
            return "???";
        }
        try {
            StringBuilder diff = new StringBuilder(ReplayAction.diff("Jenkinsfile", originalAction.getOriginalScript(), this.getOriginalScript()));
            Map<String, String> originalLoadedScripts = originalAction.getOriginalLoadedScripts();
            for (Map.Entry<String, String> entry : this.getOriginalLoadedScripts().entrySet()) {
                String script = entry.getKey();
                String originalScript = originalLoadedScripts.get(script);
                if (originalScript == null) continue;
                diff.append(ReplayAction.diff(script, originalScript, entry.getValue()));
            }
            return diff.toString();
        }
        catch (IOException x) {
            return Functions.printThrowable((Throwable)x);
        }
    }

    private static String diff(String script, String oldText, String nueText) throws IOException {
        Diff hunks = Diff.diff((Reader)new StringReader(oldText), (Reader)new StringReader(nueText), (boolean)false);
        return hunks.isEmpty() ? "" : hunks.toUnifiedDiff("old/" + script, "new/" + script, (Reader)new StringReader(oldText), (Reader)new StringReader(nueText), 3);
    }

    @RequirePOST
    public FormValidation doCheckScript() {
        return FormValidation.ok();
    }

    @RequirePOST
    public JSON doCheckScriptCompile(@AncestorInPath Item job, @QueryParameter String value) {
        return ((CpsFlowDefinition.DescriptorImpl)Jenkins.get().getDescriptorByType(CpsFlowDefinition.DescriptorImpl.class)).doCheckScriptCompile(job, value);
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED, before=InitMilestone.EXTENSIONS_AUGMENTED)
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="getEnabled return value discarded")
    public static void ensurePermissionRegistered() {
        REPLAY.getEnabled();
    }

    @Extension
    public static class Factory
    extends TransientActionFactory<Run> {
        public Class<Run> type() {
            return Run.class;
        }

        public Collection<? extends Action> createFor(Run run) {
            return run instanceof FlowExecutionOwner.Executable && run.getParent() instanceof ParameterizedJobMixIn.ParameterizedJob ? Collections.singleton(new ReplayAction(run)) : Collections.emptySet();
        }
    }
}

