/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.model.Result;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.DynamicContext;
import org.jenkinsci.plugins.workflow.support.DefaultStepContext;

@Immutable
final class ContextVariableSet
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ContextVariableSet.class.getName());
    private final ContextVariableSet parent;
    private final List<Object> values = new ArrayList<Object>();
    private static final ThreadLocal<Set<DynamicContextQuery>> dynamicContextClasses = ThreadLocal.withInitial(HashSet::new);
    private static final long serialVersionUID = 1L;

    ContextVariableSet(ContextVariableSet parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T get(Class<T> key, final ThrowingSupplier<FlowExecution> execution, final ThrowingSupplier<FlowNode> node) throws IOException, InterruptedException {
        for (Object v : this.values) {
            if (!key.isInstance(v)) continue;
            LOGGER.fine(() -> "found a " + v.getClass().getName() + " in " + this);
            return key.cast(v);
        }
        class Delegate
        extends DefaultStepContext
        implements DynamicContext.DelegatedContext {
            Delegate() {
            }

            protected <T> T doGet(Class<T> key) throws IOException, InterruptedException {
                return ContextVariableSet.this.get(key, execution, node);
            }

            protected FlowExecution getExecution() throws IOException {
                return (FlowExecution)execution.get();
            }

            protected FlowNode getNode() throws IOException {
                return (FlowNode)node.get();
            }

            public void onSuccess(Object result) {
                throw new AssertionError();
            }

            public boolean isReady() {
                throw new AssertionError();
            }

            public ListenableFuture<Void> saveState() {
                throw new AssertionError();
            }

            public void setResult(Result r) {
                throw new AssertionError();
            }

            public BodyInvoker newBodyInvoker() throws IllegalStateException {
                throw new AssertionError();
            }

            @SuppressFBWarnings(value={"EQ_UNUSUAL"}, justification="DefaultStepContext does not delegate to this")
            public boolean equals(Object o) {
                throw new AssertionError();
            }

            public int hashCode() {
                throw new AssertionError();
            }

            public void onFailure(Throwable t) {
                throw new AssertionError();
            }
        }
        Delegate delegate = new Delegate();
        for (DynamicContext dynamicContext : ExtensionList.lookup(DynamicContext.class)) {
            DynamicContextQuery query = new DynamicContextQuery(dynamicContext, key);
            Set<DynamicContextQuery> dynamicStack = dynamicContextClasses.get();
            if (!dynamicStack.add(query)) continue;
            try {
                Object v = dynamicContext.get(key, (DynamicContext.DelegatedContext)delegate);
                if (v == null) continue;
                LOGGER.fine(() -> "looked up a " + v.getClass().getName() + " from " + dynamicContext + " in " + this);
                Object object = v;
                return (T)object;
            }
            finally {
                dynamicStack.remove(query);
            }
        }
        if (this.parent != null) {
            return this.parent.get(key, execution, node);
        }
        return null;
    }

    public String toString() {
        return "ContextVariableSet" + this.values.stream().map(Object::getClass).map(Class::getName).collect(Collectors.toList()) + (String)(this.parent != null ? "<" + this.parent : "");
    }

    public static ContextVariableSet from(ContextVariableSet parent, List<Object> overrides) {
        if (overrides == null || overrides.isEmpty()) {
            return parent;
        }
        ContextVariableSet o = new ContextVariableSet(parent);
        o.values.addAll(overrides);
        return o;
    }

    @FunctionalInterface
    static interface ThrowingSupplier<T> {
        public T get() throws IOException;
    }

    private static final class DynamicContextQuery {
        final DynamicContext dynamicContext;
        final Class<?> key;

        DynamicContextQuery(DynamicContext dynamicContext, Class<?> key) {
            this.dynamicContext = dynamicContext;
            this.key = key;
        }

        public boolean equals(Object obj) {
            return obj instanceof DynamicContextQuery && this.dynamicContext == ((DynamicContextQuery)obj).dynamicContext && this.key == ((DynamicContextQuery)obj).key;
        }

        public int hashCode() {
            return this.dynamicContext.hashCode() ^ this.key.hashCode();
        }
    }
}

