/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.cps.BodyReference;
import org.jenkinsci.plugins.workflow.cps.CpsBodyExecution;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;

public final class CpsBodyInvoker
extends BodyInvoker {
    final List<Object> contextOverrides = new ArrayList<Object>();
    final BodyReference body;
    private final CpsStepContext owner;
    private List<BodyExecutionCallback> callbacks = new ArrayList<BodyExecutionCallback>();
    final List<Action> startNodeActions = new ArrayList<Action>();
    private String displayName;
    private CpsBodyExecution execution;
    private final boolean unexport;

    CpsBodyInvoker(CpsStepContext owner, BodyReference body, boolean unexport) {
        this.owner = owner;
        this.body = body;
        this.unexport = unexport;
    }

    public CpsBodyInvoker withContext(Object override) {
        this.contextOverrides.add(override);
        return this;
    }

    public BodyInvoker withContexts(Collection<?> overrides) {
        this.contextOverrides.addAll(overrides);
        return this;
    }

    public CpsBodyInvoker withStartAction(Action a) {
        this.startNodeActions.add(a);
        return this;
    }

    public CpsBodyInvoker withCallback(BodyExecutionCallback callback) {
        this.callbacks.add(callback);
        return this;
    }

    public CpsBodyInvoker withDisplayName(@NonNull String name) {
        this.displayName = name;
        return this;
    }

    public CpsBodyExecution start() {
        if (this.execution != null) {
            throw new IllegalStateException("Already started");
        }
        this.execution = new CpsBodyExecution(this.owner, this.callbacks, this.unexport ? this.body : null);
        if (this.displayName != null) {
            this.startNodeActions.add((Action)new LabelAction(this.displayName));
        }
        if (this.owner.isCompleted()) {
            throw new IllegalStateException("The " + this.owner.getDisplayName() + " step has already completed.");
        }
        boolean addedSynchrously = this.owner.withBodyInvokers(bodyInvokers -> {
            if (this.owner.isSyncMode()) {
                bodyInvokers.add(this);
                return true;
            }
            return false;
        });
        if (!addedSynchrously) {
            try {
                this.owner.getExecution().runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

                    public void onSuccess(CpsThreadGroup g) {
                        CpsThread thread = CpsBodyInvoker.this.owner.getThread(g);
                        if (thread != null) {
                            CpsBodyInvoker.this.launch(thread);
                        }
                    }

                    public void onFailure(Throwable t) {
                        CpsBodyInvoker.this.execution.onFailure.receive((Object)t);
                    }
                });
            }
            catch (IOException e) {
                this.execution.onFailure.receive((Object)e);
            }
        }
        return this.execution;
    }

    @CpsVmThreadOnly
    void launch(CpsThread currentThread) {
        this.launch(currentThread, currentThread.head);
    }

    @CpsVmThreadOnly
    void launch(CpsThread currentThread, FlowHead head) {
        this.execution.launch(this, currentThread, head);
    }
}

