/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.GroovyClassLoaderWhitelist;

@SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="irrelevant")
class CpsGroovyShell
extends GroovyShell {
    private static final Logger LOGGER = Logger.getLogger(CpsGroovyShell.class.getName());
    @CheckForNull
    private final CpsFlowExecution execution;

    CpsGroovyShell(ClassLoader parent, @CheckForNull CpsFlowExecution execution, CompilerConfiguration cc) {
        this(execution, cc, execution != null ? new TimingLoader(parent, execution) : parent);
    }

    private CpsGroovyShell(@CheckForNull CpsFlowExecution execution, CompilerConfiguration cc, ClassLoader usuallyTimingLoader) {
        super(usuallyTimingLoader, new Binding(), cc);
        this.execution = execution;
        try {
            Field loaderF = GroovyShell.class.getDeclaredField("loader");
            loaderF.setAccessible(true);
            loaderF.set((Object)this, (Object)new CleanGroovyClassLoader(usuallyTimingLoader, cc));
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "failed to install CleanGroovyClassLoader", x);
        }
    }

    public void prepareScript(Script script) {
        if (script instanceof CpsScript) {
            CpsScript cs = (CpsScript)script;
            cs.execution = this.execution;
            try {
                cs.$initialize();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Script parse(GroovyCodeSource codeSource) throws CompilationFailedException {
        Script s = this.doParse(codeSource);
        if (this.execution != null) {
            this.execution.loadedScripts.put(s.getClass().getSimpleName(), codeSource.getScriptText());
            this.execution.saveExecutionIfDurable();
        }
        this.prepareScript(s);
        return s;
    }

    Script reparse(String className, String text) throws CompilationFailedException {
        return this.doParse(new GroovyCodeSource(text, className, "/groovy/shell"));
    }

    private Script doParse(GroovyCodeSource codeSource) throws CompilationFailedException {
        GroovySandbox sandbox = new GroovySandbox();
        if (this.execution != null) {
            sandbox.withWhitelist((Whitelist)new GroovyClassLoaderWhitelist(Whitelist.all(), this.execution.getTrustedShell().getClassLoader(), this.execution.getShell().getClassLoader()));
        } else {
            sandbox.withWhitelist((Whitelist)new GroovyClassLoaderWhitelist(Whitelist.all(), this.getClassLoader()));
        }
        try (GroovySandbox.Scope scope = sandbox.enter();){
            if (this.execution != null) {
                try (CpsFlowExecution.Timing t = this.execution.time(CpsFlowExecution.TimingKind.parse);){
                    Script script = scope.parse((GroovyShell)this, codeSource);
                    return script;
                }
            }
            Script script = scope.parse((GroovyShell)this, codeSource);
            return script;
        }
    }

    protected synchronized String generateScriptName() {
        if (this.execution != null) {
            return "Script" + (this.execution.loadedScripts.size() + 1) + ".groovy";
        }
        return super.generateScriptName();
    }

    static class TimingLoader
    extends ClassLoader {
        @NonNull
        private final CpsFlowExecution execution;

        TimingLoader(ClassLoader parent, @NonNull CpsFlowExecution execution) {
            super(parent);
            this.execution = execution;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try (CpsFlowExecution.Timing t = this.execution.time(CpsFlowExecution.TimingKind.classLoad);){
                Class<?> clazz = super.loadClass(name, resolve);
                return clazz;
            }
        }

        @Override
        public URL getResource(String name) {
            try (CpsFlowExecution.Timing t = this.execution.time(CpsFlowExecution.TimingKind.classLoad);){
                URL uRL = super.getResource(name);
                return uRL;
            }
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            try (CpsFlowExecution.Timing t = this.execution.time(CpsFlowExecution.TimingKind.classLoad);){
                Enumeration<URL> enumeration = super.getResources(name);
                return enumeration;
            }
        }
    }

    private static final class CleanGroovyClassLoader
    extends GroovyClassLoader {
        private static final Pattern JAR_URL = Pattern.compile("jar:(file:/.+[.]jar)!/.+");

        CleanGroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
            super(loader, config);
        }

        protected GroovyClassLoader.ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
            return new CleanClassCollector(unit, su);
        }

        public URL findResource(String name) {
            final URL url = super.findResource(name);
            if (url != null && url.getProtocol().equals("jar")) {
                try {
                    return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL url2) throws IOException {
                            final URLConnection delegate = url.openConnection();
                            return new URLConnection(url2){

                                @Override
                                public void connect() throws IOException {
                                    delegate.connect();
                                }

                                @Override
                                public InputStream getInputStream() throws IOException {
                                    return delegate.getInputStream();
                                }

                                @Override
                                public String getHeaderField(String name) {
                                    return delegate.getHeaderField(name);
                                }

                                @Override
                                public long getLastModified() {
                                    Matcher m = JAR_URL.matcher(this.url.toString());
                                    if (m.matches()) {
                                        return new File(URI.create(m.group(1))).lastModified();
                                    }
                                    return delegate.getLastModified();
                                }

                                @Override
                                public String getContentEncoding() {
                                    return null;
                                }
                            };
                        }
                    });
                }
                catch (MalformedURLException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }
            return url;
        }

        private final class CleanClassCollector
        extends GroovyClassLoader.ClassCollector {
            CleanClassCollector(CompilationUnit unit, SourceUnit su) {
                super(null, unit, su);
            }

            public GroovyClassLoader getDefiningClassLoader() {
                return CleanGroovyClassLoader.this;
            }
        }
    }
}

