/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.durable_task;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.TaskListener;
import java.util.Map;
import org.jenkinsci.plugins.durabletask.BourneShellScript;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.durable_task.DurableTaskStep;
import org.kohsuke.stapler.DataBoundConstructor;

public final class ShellStep
extends DurableTaskStep {
    private final String script;

    @DataBoundConstructor
    public ShellStep(String script) {
        if (script == null) {
            throw new IllegalArgumentException();
        }
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    protected DurableTask task() {
        return new BourneShellScript(this.script);
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        String path = (String)((EnvVars)context.get(EnvVars.class)).get((Object)"PATH");
        if (path != null && path.contains("$PATH")) {
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("Warning: JENKINS-41339 probably bogus PATH=" + path + "; perhaps you meant to use \u2018PATH+EXTRA=/something/bin\u2019?");
        }
        return super.start(context);
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskStep.DurableTaskStepDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Shell Script";
        }

        public String getFunctionName() {
            return "sh";
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Object script = namedArgs.get("script");
            return script instanceof String ? (String)script : null;
        }
    }
}

