/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.XmlFile;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleNote;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.model.listeners.SaveableListener;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.slaves.NodeProperty;
import hudson.util.Iterators;
import hudson.util.LogTaskListener;
import hudson.util.NullStream;
import hudson.util.PersistedList;
import hudson.util.XStream2;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.model.lazy.BuildReference;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.model.queue.AsynchronousExecution;
import jenkins.scm.RunWithSCM;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.flow.BlockableResume;
import org.jenkinsci.plugins.workflow.flow.DurabilityHintProvider;
import org.jenkinsci.plugins.workflow.flow.FlowCopier;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.job.AfterRestartTask;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.console.NewNodeConsoleNote;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.PipelineIOUtils;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.concurrent.WithThreadName;
import org.jenkinsci.plugins.workflow.support.steps.input.POSTHyperlinkNote;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

@SuppressFBWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE_BOOLEAN"}, justification="For Boolean comparison, this is for deserializing handle null completion states from legacy builds")
public final class WorkflowRun
extends Run<WorkflowJob, WorkflowRun>
implements FlowExecutionOwner.Executable,
LazyBuildMixIn.LazyLoadingRun<WorkflowJob, WorkflowRun>,
RunWithSCM<WorkflowJob, WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowRun.class.getName());
    @CheckForNull
    volatile FlowExecution execution;
    @CheckForNull
    private volatile transient SettableFuture<FlowExecution> executionPromise = SettableFuture.create();
    private final transient LazyBuildMixIn.RunMixIn<WorkflowJob, WorkflowRun> runMixIn = new LazyBuildMixIn.RunMixIn<WorkflowJob, WorkflowRun>(){

        protected WorkflowRun asRun() {
            return WorkflowRun.this;
        }
    };
    private volatile transient BuildListener listener;
    private transient boolean allowTerm;
    private transient boolean allowKill;
    volatile transient boolean executionLoaded = false;
    private volatile Set<String> culprits;
    volatile Boolean completed;
    private volatile transient Object metadataGuard = new Object();
    @CheckForNull
    private List<SCMCheckout> checkouts;
    private transient List<ChangeLogSet<? extends ChangeLogSet.Entry>> changeSets;
    private transient boolean firstTime;
    static final StreamBuildListener NULL_LISTENER = new StreamBuildListener((OutputStream)new NullStream());
    private static final Map<String, WorkflowRun> LOADING_RUNS = new HashMap<String, WorkflowRun>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMetadataGuard() {
        if (this.metadataGuard == null) {
            WorkflowRun workflowRun = this;
            synchronized (workflowRun) {
                if (this.metadataGuard == null) {
                    this.metadataGuard = new Object();
                }
            }
        }
        assert (!Thread.holdsLock((Object)this) || Thread.holdsLock(this.metadataGuard)) : "Synchronizing on WorkflowRun before metadataGuard may cause deadlocks";
        return this.metadataGuard;
    }

    private BuildListener getListener() {
        if (this.listener == null) {
            if (Boolean.TRUE.equals(this.completed)) {
                LOGGER.log(Level.WARNING, null, new IllegalStateException("trying to open a build log on " + (Object)((Object)this) + " after it has completed"));
                return NULL_LISTENER;
            }
            try {
                this.listener = TaskListenerDecorator.apply((TaskListener)LogStorage.of((FlowExecutionOwner)this.asFlowExecutionOwner()).overallListener(), (FlowExecutionOwner)this.asFlowExecutionOwner(), null);
            }
            catch (IOException | InterruptedException x) {
                LOGGER.log(Level.WARNING, "Error trying to open build log file for writing, output will be lost: " + (Object)((Object)this), x);
                return NULL_LISTENER;
            }
        }
        return this.listener;
    }

    public WorkflowRun(WorkflowJob job) throws IOException {
        super((Job)job);
        this.firstTime = true;
        this.checkouts = new PersistedList((Saveable)this);
    }

    public WorkflowRun(WorkflowJob job, File dir) throws IOException {
        super((Job)job, dir);
    }

    public LazyBuildMixIn.RunMixIn<WorkflowJob, WorkflowRun> getRunMixIn() {
        return this.runMixIn;
    }

    protected BuildReference<WorkflowRun> createReference() {
        return this.getRunMixIn().createReference();
    }

    protected void dropLinks() {
        this.getRunMixIn().dropLinks();
    }

    @Exported
    public WorkflowRun getPreviousBuild() {
        return (WorkflowRun)this.getRunMixIn().getPreviousBuild();
    }

    @Exported
    public WorkflowRun getNextBuild() {
        return (WorkflowRun)this.getRunMixIn().getNextBuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.firstTime) {
            throw this.sleep();
        }
        try {
            this.onStartBuilding();
            this.charset = "UTF-8";
            BuildListener myListener = this.getListener();
            myListener.started(this.getCauses());
            Authentication auth = Jenkins.getAuthentication();
            if (!auth.equals(ACL.SYSTEM)) {
                User user;
                String name = auth.getName();
                if (!auth.equals(Jenkins.ANONYMOUS) && (user = User.getById((String)name, (boolean)false)) != null) {
                    name = ModelHyperlinkNote.encodeTo((User)user);
                }
                myListener.getLogger().println("Running as " + name);
            }
            RunListener.fireStarted((Run)this, (TaskListener)myListener);
            this.updateSymlinks((TaskListener)myListener);
            FlowDefinition definition = ((WorkflowJob)this.getParent()).getDefinition();
            if (definition == null) {
                throw new AbortException("No flow definition, cannot run");
            }
            Owner owner = new Owner(this);
            FlowExecution newExecution = definition.create((FlowExecutionOwner)owner, (TaskListener)myListener, this.getAllActions());
            boolean loggedHintOverride = false;
            if (newExecution instanceof BlockableResume) {
                boolean blockResume = ((WorkflowJob)this.getParent()).isResumeBlocked();
                ((BlockableResume)newExecution).setResumeBlocked(blockResume);
                if (blockResume) {
                    myListener.getLogger().println("Resume disabled by user, switching to high-performance, low-durability mode.");
                    loggedHintOverride = true;
                }
            }
            if (!loggedHintOverride) {
                myListener.getLogger().println("Running in Durability level: " + DurabilityHintProvider.suggestedFor((Item)this.project));
            }
            this.save();
            Object blockResume = this.getMetadataGuard();
            synchronized (blockResume) {
                FlowExecutionList.get().register((FlowExecutionOwner)owner);
                newExecution.addListener((GraphListener)new GraphL());
                newExecution.addListener((GraphListener)new NodePrintListener());
                this.completed = Boolean.FALSE;
                this.executionLoaded = true;
                this.execution = newExecution;
            }
            SettableFuture<FlowExecution> exec = this.getSettableExecutionPromise();
            if (!exec.isDone()) {
                exec.set((Object)newExecution);
            }
            FlowExecutionListener.fireCreated((FlowExecution)newExecution);
            newExecution.start();
            FlowExecutionListener.fireRunning((FlowExecution)newExecution);
        }
        catch (Throwable x) {
            block19: {
                this.execution = null;
                this.executionLoaded = true;
                Executor executor = Executor.currentExecutor();
                if (Thread.interrupted() && executor != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, (Object)((Object)this) + " was interrupted during startup", x);
                    }
                    Result result = executor.abortResult();
                    Collection causes = executor.getCausesOfInterruption();
                    this.finish(result, (Throwable)new FlowInterruptedException(result, causes.toArray(new CauseOfInterruption[causes.size()])));
                } else {
                    this.finish(Result.FAILURE, x);
                }
                try {
                    SettableFuture<FlowExecution> exec = this.getSettableExecutionPromise();
                    if (!exec.isDone()) {
                        exec.setException(x);
                    }
                }
                catch (Error e) {
                    if (e == x) break block19;
                    throw e;
                }
            }
            return;
        }
        throw this.sleep();
    }

    private AsynchronousExecution sleep() {
        return new AsynchronousExecution(){

            public void interrupt(boolean forShutdown) {
                if (forShutdown) {
                    return;
                }
                Timer.get().submit(() -> {
                    FlowExecution fetchedExecution = WorkflowRun.this.execution;
                    if (fetchedExecution == null) {
                        return;
                    }
                    Executor executor = this.getExecutor();
                    if (executor == null) {
                        LOGGER.log(Level.WARNING, "Lost executor for {0}", (Object)WorkflowRun.this);
                        return;
                    }
                    try {
                        Collection causes = executor.getCausesOfInterruption();
                        fetchedExecution.interrupt(executor.abortResult(), causes.toArray(new CauseOfInterruption[causes.size()]));
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                    executor.recordCauseOfInterruption((Run)WorkflowRun.this, (TaskListener)WorkflowRun.this.getListener());
                    WorkflowRun.this.printLater(StopState.TERM, "Click here to forcibly terminate running steps");
                });
            }

            public boolean blocksRestart() {
                FlowExecution exec = WorkflowRun.this.getExecution();
                return exec != null && exec.blocksRestart();
            }

            public boolean displayCell() {
                return this.blocksRestart();
            }
        };
    }

    private void printLater(StopState state, String message) {
        Timer.get().schedule(() -> {
            if (!this.isInProgress()) {
                return;
            }
            switch (state) {
                case TERM: {
                    this.allowTerm = true;
                    break;
                }
                case KILL: {
                    this.allowKill = true;
                }
            }
            this.getListener().getLogger().println(POSTHyperlinkNote.encodeTo((String)("/" + this.getUrl() + state.url()), (String)message));
        }, 15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doTerm() {
        this.checkPermission(Item.CANCEL);
        if (!this.isInProgress() || this.execution == null) {
            return;
        }
        FlowInterruptedException x = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[0]);
        FlowExecution exec = this.getExecution();
        if (exec == null) {
            Object object = this.getMetadataGuard();
            synchronized (object) {
                boolean modified = false;
                if (this.result == null) {
                    this.setResult(Result.FAILURE);
                    modified = true;
                }
                if (!Boolean.TRUE.equals(this.completed)) {
                    this.completed = true;
                    modified = true;
                }
                if (modified) {
                    this.saveWithoutFailing();
                }
                return;
            }
        }
        Futures.addCallback((ListenableFuture)exec.getCurrentExecutions(true), (FutureCallback)new FutureCallback<List<StepExecution>>((Throwable)x){
            final /* synthetic */ Throwable val$x;
            {
                this.val$x = throwable;
            }

            public void onSuccess(List<StepExecution> l) {
                for (StepExecution e : Iterators.reverse(l)) {
                    StepContext context = e.getContext();
                    context.onFailure(this.val$x);
                    try {
                        FlowNode n = (FlowNode)context.get(FlowNode.class);
                        if (n == null) continue;
                        WorkflowRun.this.getListener().getLogger().println("Terminating " + n.getDisplayFunctionName());
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.FINE, null, x);
                    }
                }
            }

            public void onFailure(Throwable t) {
            }
        });
        this.printLater(StopState.KILL, "Click here to forcibly kill entire build");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doKill() {
        this.checkPermission(Item.CANCEL);
        if (!this.isBuilding() || this.execution == null) {
            return;
        }
        Object object = this.getMetadataGuard();
        synchronized (object) {
            this.getListener().getLogger().println("Hard kill!");
        }
        object = this;
        synchronized (object) {
            this.execution = null;
            this.executionLoaded = true;
        }
        FlowInterruptedException suddenDeath = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[0]);
        this.finish(Result.ABORTED, (Throwable)suddenDeath);
        this.getSettableExecutionPromise().setException((Throwable)suddenDeath);
    }

    public EnvVars getEnvironment(TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = super.getEnvironment(listener);
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance != null) {
            for (NodeProperty nodeProperty : instance.getGlobalNodeProperties()) {
                nodeProperty.buildEnvVars(env, listener);
            }
        }
        EnvVars.resolve((Map)env);
        return env;
    }

    @Restricted(value={DoNotUse.class})
    public boolean hasAllowTerm() {
        return this.isBuilding() && this.allowTerm;
    }

    @Restricted(value={DoNotUse.class})
    public boolean hasAllowKill() {
        return this.isBuilding() && this.allowKill;
    }

    private String key() {
        return ((WorkflowJob)this.getParent()).getFullName() + '/' + this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws IOException {
        Map<String, WorkflowRun> map = LOADING_RUNS;
        synchronized (map) {
            LOADING_RUNS.put(this.key(), this);
        }
        new XmlFile(XSTREAM, new File(this.getRootDir(), "build.xml")).unmarshal((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLoad() {
        try {
            Map<String, WorkflowRun> map = this.getMetadataGuard();
            synchronized (map) {
                block28: {
                    if (!this.executionLoaded) break block28;
                    LOGGER.log(Level.WARNING, "Double onLoad of build " + (Object)((Object)this));
                    return;
                }
                boolean needsToPersist = this.completed == null;
                super.onLoad();
                if (Boolean.TRUE.equals(this.completed) && this.result == null) {
                    LOGGER.log(Level.FINE, "Completed build with no result set, defaulting to failure for " + (Object)((Object)this));
                    this.setResult(Result.FAILURE);
                    needsToPersist = true;
                }
                if (this.execution != null && !Boolean.TRUE.equals(this.completed)) {
                    FlowExecution fetchedExecution = this.getExecution();
                    if (fetchedExecution != null) {
                        if (this.completed == null) {
                            this.completed = fetchedExecution.isComplete();
                        }
                        if (Boolean.FALSE.equals(this.completed)) {
                            FlowExecutionListener.fireResumed((FlowExecution)fetchedExecution);
                            this.getListener().getLogger().println("Resuming build at " + new Date() + " after Jenkins restart");
                            Timer.get().submit(() -> Queue.getInstance().schedule((Queue.Task)new AfterRestartTask(this), 0));
                        }
                    } else {
                        this.completed = Boolean.TRUE;
                    }
                } else if (this.execution == null) {
                    this.completed = Boolean.TRUE;
                }
                if (needsToPersist && this.completed.booleanValue()) {
                    try {
                        this.save();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Error while saving build to update completed flag " + (Object)((Object)this), ex);
                    }
                }
            }
        }
        finally {
            this.checkouts(null);
            Map<String, WorkflowRun> map = LOADING_RUNS;
            synchronized (map) {
                LOADING_RUNS.remove(this.key());
                LOADING_RUNS.notifyAll();
            }
        }
    }

    public void setResult(Result r) {
        if (this.result == null || r.isWorseThan(this.result)) {
            this.result = r;
            LOGGER.log(Level.FINE, (Object)((Object)this) + " in " + this.getRootDir() + ": result is set to " + r, LOGGER.isLoggable(Level.FINER) ? new Exception() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(@Nonnull Result r, @CheckForNull Throwable t) {
        try {
            BuildListener myListener;
            this.setResult(r);
            Object object = this.getMetadataGuard();
            synchronized (object) {
                myListener = this.getListener();
                this.completed = true;
            }
            this.duration = Math.max(0L, System.currentTimeMillis() - this.getStartTimeInMillis());
            LOGGER.log(Level.INFO, "{0} completed: {1}", new Object[]{this.toString(), this.getResult()});
            if (myListener == null) {
                LOGGER.log(Level.WARNING, (Object)((Object)this) + " failed to start", t);
            } else {
                RunListener.fireCompleted((Run)this, (TaskListener)myListener);
                this.fireCompleted();
                if (t instanceof AbortException) {
                    myListener.error(t.getMessage());
                } else if (t instanceof FlowInterruptedException) {
                    ((FlowInterruptedException)t).handle((Run)this, (TaskListener)myListener);
                } else if (t != null) {
                    Functions.printStackTrace((Throwable)t, (PrintStream)myListener.getLogger());
                }
                myListener.finished(this.getResult());
                if (myListener instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)myListener).close();
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, "could not close build log for " + (Object)((Object)this), x);
                    }
                }
            }
            this.saveWithoutFailing();
            Timer.get().submit(() -> {
                try {
                    ((WorkflowJob)this.getParent()).logRotate();
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "failed to perform log rotation after " + (Object)((Object)this), x);
                }
            });
            this.onEndBuilding();
        }
        finally {
            FlowExecutionList.get().unregister((FlowExecutionOwner)new Owner(this));
            this.listener = null;
        }
        try {
            StashManager.maybeClearAll((Run)this, (TaskListener)new LogTaskListener(LOGGER, Level.FINE));
        }
        catch (IOException | InterruptedException x) {
            LOGGER.log(Level.WARNING, "failed to clean up stashes from " + (Object)((Object)this), x);
        }
    }

    private void fireCompleted() {
        FlowExecution exec = this.getExecution();
        if (exec != null) {
            FlowExecutionListener.fireCompleted((FlowExecution)exec);
        }
    }

    public void deleteArtifacts() throws IOException {
        super.deleteArtifacts();
        try {
            StashManager.clearAll((Run)this, (TaskListener)new LogTaskListener(LOGGER, Level.FINE));
        }
        catch (InterruptedException x) {
            throw new IOException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public FlowExecution getExecution() {
        if (this.executionLoaded || this.execution == null) {
            return this.execution;
        }
        WorkflowRun workflowRun = this;
        synchronized (workflowRun) {
            FlowExecution fetchedExecution = this.execution;
            if (this.executionLoaded || fetchedExecution == null) {
                return fetchedExecution;
            }
            try {
                SettableFuture<FlowExecution> settablePromise;
                if (fetchedExecution instanceof BlockableResume) {
                    BlockableResume blockableExecution = (BlockableResume)fetchedExecution;
                    boolean parentBlocked = ((WorkflowJob)this.getParent()).isResumeBlocked();
                    if (parentBlocked != blockableExecution.isResumeBlocked()) {
                        blockableExecution.setResumeBlocked(parentBlocked);
                    }
                }
                FailOnLoadListener finishListener = null;
                if (!Boolean.TRUE.equals(this.completed)) {
                    finishListener = new FailOnLoadListener();
                    fetchedExecution.addListener((GraphListener)finishListener);
                }
                fetchedExecution.onLoad((FlowExecutionOwner)new Owner(this));
                if (!Boolean.TRUE.equals(this.completed)) {
                    if (fetchedExecution.isComplete()) {
                        LOGGER.log(Level.WARNING, "Found incomplete build with completed execution - display name: " + this.getFullDisplayName());
                        this.completed = true;
                        Result finalResult = Result.FAILURE;
                        List heads = fetchedExecution.getCurrentHeads();
                        if (!heads.isEmpty() && heads.get(0) instanceof FlowEndNode) {
                            finalResult = ((FlowEndNode)heads.get(0)).getResult();
                        }
                        this.setResult(finalResult);
                        fetchedExecution.removeListener((GraphListener)finishListener);
                        this.saveWithoutFailing();
                    } else {
                        fetchedExecution.removeListener((GraphListener)finishListener);
                        fetchedExecution.addListener((GraphListener)new GraphL());
                        fetchedExecution.addListener((GraphListener)new NodePrintListener());
                    }
                }
                if (!(settablePromise = this.getSettableExecutionPromise()).isDone()) {
                    settablePromise.set((Object)fetchedExecution);
                }
                this.executionLoaded = true;
                return fetchedExecution;
            }
            catch (Exception x) {
                if (this.result == null) {
                    this.setResult(Result.FAILURE);
                }
                LOGGER.log(Level.WARNING, "Nulling out FlowExecution due to error in build " + (Object)((Object)this), x);
                this.execution = null;
                this.executionLoaded = true;
                this.saveWithoutFailing();
                return null;
            }
        }
    }

    @Nonnull
    public ListenableFuture<FlowExecution> getExecutionPromise() {
        return this.getSettableExecutionPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private SettableFuture<FlowExecution> getSettableExecutionPromise() {
        SettableFuture execOut = this.executionPromise;
        if (execOut == null) {
            WorkflowRun workflowRun = this;
            synchronized (workflowRun) {
                execOut = this.executionPromise;
                if (execOut == null) {
                    this.executionPromise = execOut = SettableFuture.create();
                }
                return execOut;
            }
        }
        return execOut;
    }

    @Nonnull
    public FlowExecutionOwner asFlowExecutionOwner() {
        return new Owner(this);
    }

    public boolean hasntStartedYet() {
        return this.result == null && this.execution == null;
    }

    public boolean isBuilding() {
        return this.result == null || this.isInProgress();
    }

    @Exported
    protected boolean isInProgress() {
        if (Boolean.TRUE.equals(this.completed)) {
            return false;
        }
        FlowExecution exec = this.getExecution();
        return exec != null && !exec.isComplete();
    }

    public boolean isLogUpdated() {
        return this.listener != null || this.isBuilding();
    }

    @Nonnull
    synchronized List<SCMCheckout> checkouts(@CheckForNull TaskListener listener) {
        if (this.checkouts == null) {
            LOGGER.log(Level.WARNING, "JENKINS-26761: no checkouts in {0}", (Object)this);
            if (listener != null) {
                listener.error("JENKINS-26761: list of SCM checkouts in " + (Object)((Object)this) + " was lost; polling will be broken");
            }
            this.checkouts = new PersistedList((Saveable)this);
        }
        return this.checkouts;
    }

    @Nonnull
    public List<SCM> getSCMs() {
        List<SCMCheckout> scmCheckouts = this.checkouts(TaskListener.NULL);
        ArrayList<SCM> scmList = new ArrayList<SCM>();
        for (SCMCheckout checkout : scmCheckouts) {
            scmList.add(checkout.getScm());
        }
        return scmList;
    }

    @Exported
    public synchronized List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChangeSets() {
        if (this.changeSets == null) {
            this.changeSets = new ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>>();
            for (SCMCheckout co : this.checkouts(null)) {
                if (co.changelogFile == null || !co.changelogFile.isFile()) continue;
                try {
                    ChangeLogSet changeLogSet = co.scm.createChangeLogParser().parse((Run)this, co.scm.getEffectiveBrowser(), co.changelogFile);
                    if (changeLogSet.isEmptySet()) continue;
                    this.changeSets.add((ChangeLogSet<? extends ChangeLogSet.Entry>)changeLogSet);
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "could not parse " + co.changelogFile, x);
                }
            }
        }
        return this.changeSets;
    }

    @CheckForNull
    public Set<String> getCulpritIds() {
        if (this.shouldCalculateCulprits()) {
            HashSet<String> tempCulpritIds = new HashSet<String>();
            for (User u : this.getCulprits()) {
                tempCulpritIds.add(u.getId());
            }
            if (this.isBuilding()) {
                return ImmutableSortedSet.copyOf(tempCulpritIds);
            }
            this.culprits = ImmutableSortedSet.copyOf(tempCulpritIds);
        }
        return this.culprits;
    }

    @Exported
    @Nonnull
    public Set<User> getCulprits() {
        return super.getCulprits();
    }

    public boolean shouldCalculateCulprits() {
        return this.isBuilding() || this.culprits == null;
    }

    @RequirePOST
    public synchronized HttpResponse doStop() {
        Executor e = this.getOneOffExecutor();
        if (e != null) {
            return e.doStop();
        }
        this.doKill();
        return HttpResponses.forwardToPreviousPage();
    }

    private void onCheckout(SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) throws Exception {
        if (changelogFile != null && changelogFile.isFile()) {
            ChangeLogSet cls = scm.createChangeLogParser().parse((Run)this, scm.getEffectiveBrowser(), changelogFile);
            if (!cls.isEmptySet()) {
                this.getChangeSets().add((ChangeLogSet<? extends ChangeLogSet.Entry>)cls);
            }
            for (SCMListener l : SCMListener.all()) {
                l.onChangeLogParsed((Run)this, scm, listener, cls);
            }
        }
        this.checkouts(listener).add(new SCMCheckout(scm, FilePathUtils.getNodeName((FilePath)workspace), workspace.getRemote(), changelogFile, pollingBaseline));
    }

    public AnnotatedLargeText getLogText() {
        return LogStorage.of((FlowExecutionOwner)this.asFlowExecutionOwner()).overallLog((FlowExecutionOwner.Executable)this, !this.isLogUpdated());
    }

    @Restricted(value={DoNotUse.class})
    public String getFlowGraphDataAsHtml() {
        DepthFirstScanner scanner;
        FlowExecution exec = this.getExecution();
        if (exec != null && (scanner = new DepthFirstScanner()).setup((Collection)exec.getCurrentHeads())) {
            StringBuilder html = new StringBuilder();
            for (FlowNode node : scanner) {
                String startId;
                String enclosingId;
                if (node instanceof BlockEndNode) {
                    enclosingId = null;
                    startId = ((BlockEndNode)node).getStartNode().getId();
                } else {
                    Iterator it = node.iterateEnclosingBlocks().iterator();
                    enclosingId = it.hasNext() ? ((BlockStartNode)it.next()).getId() : null;
                    startId = node instanceof BlockStartNode ? node.getId() : null;
                }
                html.append((CharSequence)NewNodeConsoleNote.startTagFor(this, node.getId(), startId, enclosingId)).append("Test</span>");
            }
            return html.toString();
        }
        return null;
    }

    public InputStream getLogInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeLogTo((arg_0, arg_1) -> ((AnnotatedLargeText)this.getLogText()).writeRawLogTo(arg_0, arg_1), baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public void doConsoleText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/plain;charset=UTF-8");
        try (OutputStream os = rsp.getCompressedOutputStream((HttpServletRequest)req);){
            this.writeLogTo((arg_0, arg_1) -> ((AnnotatedLargeText)this.getLogText()).writeLogTo(arg_0, arg_1), os);
        }
    }

    public Reader getLogReader() throws IOException {
        return this.getLogText().readAll();
    }

    public String getLog() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeLogTo((arg_0, arg_1) -> ((AnnotatedLargeText)this.getLogText()).writeRawLogTo(arg_0, arg_1), baos);
        return baos.toString("UTF-8");
    }

    private void writeLogTo(WriteMethod method, OutputStream os) throws IOException {
        long pos2;
        long pos = 0L;
        while ((pos2 = method.writeLogTo(pos, os)) > pos) {
            pos = pos2;
        }
    }

    public List<String> getLog(int maxLines) throws IOException {
        int lineCount = 0;
        LinkedList<String> logLines = new LinkedList<String>();
        if (maxLines == 0) {
            return logLines;
        }
        try (BufferedReader reader = new BufferedReader(this.getLogReader());){
            String line = reader.readLine();
            while (line != null) {
                logLines.add(line);
                if (++lineCount > maxLines) {
                    logLines.remove(0);
                }
                line = reader.readLine();
            }
        }
        if (lineCount > maxLines) {
            logLines.set(0, "[...truncated " + (lineCount - (maxLines - 1)) + " lines...]");
        }
        return ConsoleNote.removeNotes(logLines);
    }

    @Deprecated
    public File getLogFile() {
        LOGGER.log(Level.WARNING, "Avoid calling getLogFile on " + (Object)((Object)this), new UnsupportedOperationException());
        return LogStorage.of((FlowExecutionOwner)this.asFlowExecutionOwner()).getLogFile((FlowExecutionOwner.Executable)this, !this.isLogUpdated());
    }

    static void alias() {
        Run.XSTREAM2.alias("flow-build", WorkflowRun.class);
        new XmlFile(null).getXStream().aliasType("flow-owner", Owner.class);
        Run.XSTREAM2.aliasType("flow-owner", Owner.class);
    }

    private void saveWithoutFailing() {
        try {
            this.save();
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "Failed to save " + (Object)((Object)this), x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        File loc = new File(this.getRootDir(), "build.xml");
        XmlFile file = new XmlFile(XSTREAM, loc);
        boolean isAtomic = true;
        FlowExecution fetchedExecution = this.execution;
        if (fetchedExecution != null) {
            FlowDurabilityHint hint = fetchedExecution.getDurabilityHint();
            isAtomic = hint.isAtomicWrite();
        }
        boolean completeAsynchronousExecution = false;
        try {
            WorkflowRun workflowRun = this;
            synchronized (workflowRun) {
                completeAsynchronousExecution = Boolean.TRUE.equals(this.completed);
                PipelineIOUtils.writeByXStream((Object)((Object)this), (File)loc, (XStream2)XSTREAM2, (boolean)isAtomic);
                SaveableListener.fireOnChange((Saveable)this, (XmlFile)file);
            }
        }
        finally {
            AsynchronousExecution asynchronousExecution;
            Executor executor;
            if (completeAsynchronousExecution && (executor = this.getExecutor()) != null && (asynchronousExecution = executor.getAsynchronousExecution()) != null) {
                asynchronousExecution.completed(null);
            }
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class Checkouts
    extends FlowCopier.ByRun {
        public void copy(Run<?, ?> original, Run<?, ?> copy, TaskListener listener) throws IOException, InterruptedException {
            if (original instanceof WorkflowRun && copy instanceof WorkflowRun) {
                ((WorkflowRun)copy).checkouts(null).addAll(((WorkflowRun)original).checkouts(null));
            }
        }
    }

    @Extension
    public static final class SCMListenerImpl
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            if (build instanceof WorkflowRun) {
                ((WorkflowRun)build).onCheckout(scm, workspace, listener, changelogFile, pollingBaseline);
            }
        }
    }

    @FunctionalInterface
    private static interface WriteMethod {
        public long writeLogTo(long var1, OutputStream var3) throws IOException;
    }

    private final class NodePrintListener
    implements GraphListener.Synchronous {
        private NodePrintListener() {
        }

        public void onNewHead(FlowNode node) {
            NewNodeConsoleNote.print(node, (TaskListener)WorkflowRun.this.getListener());
        }
    }

    private final class GraphL
    implements GraphListener {
        private GraphL() {
        }

        public void onNewHead(FlowNode node) {
            if (node.getPersistentAction(TimingAction.class) == null) {
                node.addAction((Action)new TimingAction());
            }
            FlowExecution exec = WorkflowRun.this.getExecution();
            if (node instanceof FlowEndNode) {
                WorkflowRun.this.finish(((FlowEndNode)node).getResult(), exec != null ? exec.getCauseOfFailure() : null);
            } else if (exec != null && exec.getDurabilityHint().isPersistWithEveryStep()) {
                WorkflowRun.this.saveWithoutFailing();
            }
        }
    }

    private final class FailOnLoadListener
    implements GraphListener {
        private FailOnLoadListener() {
        }

        public void onNewHead(FlowNode node) {
            if (node instanceof FlowEndNode) {
                Timer.get().schedule(() -> {
                    Object object = WorkflowRun.this.getMetadataGuard();
                    synchronized (object) {
                        WorkflowRun.this.finish(((FlowEndNode)node).getResult(), WorkflowRun.this.execution != null ? WorkflowRun.this.execution.getCauseOfFailure() : null);
                    }
                }, 1L, TimeUnit.SECONDS);
            }
        }
    }

    private static final class Owner
    extends FlowExecutionOwner {
        private final String job;
        private final String id;
        @CheckForNull
        private transient WorkflowRun run;
        private static final long serialVersionUID = 1L;

        Owner(WorkflowRun run) {
            this.job = ((WorkflowJob)run.getParent()).getFullName();
            this.id = run.getId();
            this.run = run;
        }

        private String key() {
            return this.job + '/' + this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        private WorkflowRun run() throws IOException {
            if (this.run == null) {
                WorkflowRun candidate;
                Map map = LOADING_RUNS;
                synchronized (map) {
                    candidate = (WorkflowRun)((Object)LOADING_RUNS.get(this.key()));
                }
                if (candidate != null && ((WorkflowJob)candidate.getParent()).getFullName().equals(this.job) && candidate.getId().equals(this.id)) {
                    this.run = candidate;
                } else {
                    WorkflowJob j;
                    Jenkins jenkins = Jenkins.getInstanceOrNull();
                    if (jenkins == null) {
                        throw new IOException("Jenkins is not running");
                    }
                    try (ACLContext context = ACL.as((Authentication)ACL.SYSTEM);){
                        j = (WorkflowJob)jenkins.getItemByFullName(this.job, WorkflowJob.class);
                    }
                    if (j == null) {
                        throw new IOException("no such WorkflowJob " + this.job);
                    }
                    this.run = (WorkflowRun)j._getRuns().getById(this.id);
                    if (this.run == null) {
                        throw new IOException("no such build " + this.id + " in " + this.job);
                    }
                }
            }
            return this.run;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FlowExecution get() throws IOException {
            WorkflowRun r = this.run();
            Map map = LOADING_RUNS;
            synchronized (map) {
                int count = 5;
                while (r.execution == null && LOADING_RUNS.containsKey(this.key()) && count-- > 0) {
                    try {
                        WithThreadName naming = new WithThreadName(": waiting for " + this.key());
                        Throwable throwable = null;
                        try {
                            LOADING_RUNS.wait(60000L);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (naming == null) continue;
                            if (throwable != null) {
                                try {
                                    naming.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            naming.close();
                        }
                    }
                    catch (InterruptedException x) {
                        LOGGER.log(Level.WARNING, "failed to wait for " + (Object)((Object)r) + " to be loaded", x);
                        break;
                    }
                }
            }
            FlowExecution exec = r.getExecution();
            if (exec != null) {
                return exec;
            }
            throw new IOException((Object)((Object)r) + " did not yet start");
        }

        public FlowExecution getOrNull() {
            try {
                WorkflowRun run = this.run();
                ListenableFuture<FlowExecution> promise = run.getExecutionPromise();
                if (promise.isDone()) {
                    return run.getExecution();
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, null, x);
            }
            return null;
        }

        public File getRootDir() throws IOException {
            return this.run().getRootDir();
        }

        public Queue.Executable getExecutable() throws IOException {
            return this.run();
        }

        public String getUrl() throws IOException {
            return this.run().getUrl();
        }

        public TaskListener getListener() throws IOException {
            return this.run().getListener();
        }

        public String toString() {
            return "Owner[" + this.key() + ":" + (Object)((Object)this.run) + "]";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Owner)) {
                return false;
            }
            Owner that = (Owner)((Object)o);
            return this.job.equals(that.job) && this.id.equals(that.id);
        }

        public int hashCode() {
            return this.job.hashCode() ^ this.id.hashCode();
        }
    }

    static final class SCMCheckout {
        final SCM scm;
        final String node;
        final String workspace;
        @CheckForNull
        final File changelogFile;
        @CheckForNull
        final SCMRevisionState pollingBaseline;

        SCMCheckout(SCM scm, String node, String workspace, File changelogFile, SCMRevisionState pollingBaseline) {
            this.scm = scm;
            this.node = node;
            this.workspace = workspace;
            this.changelogFile = changelogFile;
            this.pollingBaseline = pollingBaseline;
        }

        public SCM getScm() {
            return this.scm;
        }

        private Object readResolve() {
            if (this.scm == null) {
                throw new IllegalStateException("Unloadable scm field");
            }
            return this;
        }
    }

    private static enum StopState {
        TERM,
        KILL;


        public String url() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

