/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.properties;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Saveable;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.properties.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class PipelineTriggersJobProperty
extends JobProperty<WorkflowJob> {
    private static final Logger LOGGER = Logger.getLogger(PipelineTriggersJobProperty.class.getName());
    private List<Trigger<?>> triggers = new ArrayList();

    @DataBoundConstructor
    public PipelineTriggersJobProperty(List<Trigger> triggers) {
        if (triggers == null) {
            this.triggers = new ArrayList();
        } else {
            for (Trigger t : triggers) {
                this.triggers.add(t);
            }
        }
    }

    protected Object readResolve() {
        if (this.triggers == null) {
            LOGGER.log(Level.WARNING, "triggers attribute was null, this shouldn't happen.");
            this.triggers = new ArrayList();
        }
        return this;
    }

    public void setTriggers(List<Trigger<?>> triggers) {
        this.triggers = new ArrayList(triggers);
    }

    public List<Trigger<?>> getTriggers() {
        return this.triggers;
    }

    public void addTrigger(Trigger t) {
        this.triggers.add(t);
    }

    public Trigger getTriggerForDescriptor(TriggerDescriptor td) {
        for (Trigger<?> trigger : this.triggers) {
            if (!td.equals(trigger.getDescriptor())) continue;
            return trigger;
        }
        return null;
    }

    public void stopTriggers() {
        for (Trigger<?> trigger : this.triggers) {
            trigger.stop();
        }
    }

    public void startTriggers(boolean newInstance) {
        for (Trigger<?> trigger : this.triggers) {
            try {
                trigger.start((Item)this.owner, newInstance);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Can't start trigger.", ex);
            }
        }
    }

    public void removeTrigger(Trigger t) {
        Trigger toRemove = this.getTriggerForDescriptor(t.getDescriptor());
        if (toRemove != null) {
            this.triggers.remove(toRemove);
        }
    }

    public Map<TriggerDescriptor, Trigger<?>> getTriggersMap() {
        HashMap triggerMap = new HashMap();
        for (Trigger<?> t : this.getTriggers()) {
            TriggerDescriptor td = t.getDescriptor();
            triggerMap.put(td, t);
        }
        return triggerMap;
    }

    public List<Action> getAllTriggerActions() {
        ArrayList<Action> triggerActions = new ArrayList<Action>();
        for (Trigger<?> t : this.triggers) {
            triggerActions.addAll(t.getProjectActions());
        }
        return triggerActions;
    }

    @CheckForNull
    public PipelineTriggersJobProperty reconfigure(@Nonnull StaplerRequest req, @CheckForNull JSONObject form) throws Descriptor.FormException {
        DescribableList trigList = new DescribableList(Saveable.NOOP);
        try {
            JSONObject triggerSection = new JSONObject();
            if (form != null) {
                triggerSection = form.getJSONObject("triggers");
            }
            trigList.rebuild(req, triggerSection, Trigger.for_((Item)this.owner));
        }
        catch (IOException e) {
            throw new Descriptor.FormException((Throwable)e, "triggers");
        }
        PipelineTriggersJobProperty oldProp = ((WorkflowJob)this.owner).getTriggersJobProperty();
        try {
            ((WorkflowJob)this.owner).removeProperty(this);
            PipelineTriggersJobProperty thisProp = new PipelineTriggersJobProperty(new ArrayList<Trigger>(trigList.toList()));
            ((WorkflowJob)this.owner).addTriggersJobPropertyWithoutStart(thisProp);
            thisProp.startTriggers(true);
            return thisProp;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "could not configure triggers", e);
            if (((WorkflowJob)this.owner).getTriggersJobProperty() == null && oldProp != null) {
                try {
                    ((WorkflowJob)this.owner).addTriggersJobPropertyWithoutStart(oldProp);
                    oldProp.startTriggers(true);
                }
                catch (IOException e2) {
                    LOGGER.log(Level.WARNING, "could not revert to original configured triggers", e2);
                    throw new Descriptor.FormException("Could not revert to original configured triggers", (Throwable)e2, "triggers");
                }
            }
            return oldProp;
        }
    }

    @Extension
    public static class Factory
    extends TransientActionFactory<WorkflowJob> {
        public Class<WorkflowJob> type() {
            return WorkflowJob.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull WorkflowJob job) {
            return job.getTriggersJobProperty().getAllTriggerActions();
        }
    }

    @Extension(ordinal=-100.0)
    @Symbol(value={"pipelineTriggers"})
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.build_triggers();
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PipelineTriggersJobProperty prop = (PipelineTriggersJobProperty)super.newInstance(req, formData);
            return prop.triggers.isEmpty() ? null : prop;
        }
    }
}

